<?php

// Data functions (insert, update, delete, form) for table c001

// This script and data application were generated by AppGini 5.97
// Download AppGini for free from https://bigprof.com/appgini/download/

function c001_insert(&$error_message = '') {
	global $Translation;

	// mm: can member insert record?
	$arrPerm = getTablePermissions('c001');
	if(!$arrPerm['insert']) return false;

	$data = [
		'cod_categoria' => Request::val('cod_categoria', ''),
		'categoria' => Request::val('categoria', ''),
		'atividade' => br2nl(Request::val('atividade', '')),
		'descricao' => br2nl(Request::val('descricao', '')),
		'quantidade' => Request::val('quantidade', ''),
		'unidade' => Request::lookup('unidade', ''),
		'uta' => Request::val('uta', ''),
		'valor' => Request::val('valor', ''),
	];

	if($data['atividade'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Atividade': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['descricao'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Descri&#231;&#227;o / Especifica&#231;&#227;o': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}

	// hook: c001_before_insert
	if(function_exists('c001_before_insert')) {
		$args = [];
		if(!c001_before_insert($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$error = '';
	// set empty fields to NULL
	$data = array_map(function($v) { return ($v === '' ? NULL : $v); }, $data);
	insert('c001', backtick_keys_once($data), $error);
	if($error)
		die("{$error}<br><a href=\"#\" onclick=\"history.go(-1);\">{$Translation['< back']}</a>");

	$recID = db_insert_id(db_link());

	// automatic unidade if passed as filterer
	if($_REQUEST['filterer_unidade']) {
		sql("UPDATE `c001` SET `unidade`='" . makeSafe($_REQUEST['filterer_unidade']) . "' WHERE `id`='" . makeSafe($recID, false) . "'", $eo);
	}

	update_calc_fields('c001', $recID, calculated_fields()['c001']);

	// hook: c001_after_insert
	if(function_exists('c001_after_insert')) {
		$res = sql("SELECT * FROM `c001` WHERE `id`='" . makeSafe($recID, false) . "' LIMIT 1", $eo);
		if($row = db_fetch_assoc($res)) {
			$data = array_map('makeSafe', $row);
		}
		$data['selectedID'] = makeSafe($recID, false);
		$args=[];
		if(!c001_after_insert($data, getMemberInfo(), $args)) { return $recID; }
	}

	// mm: save ownership data
	set_record_owner('c001', $recID, getLoggedMemberID());

	// if this record is a copy of another record, copy children if applicable
	if(!empty($_REQUEST['SelectedID'])) c001_copy_children($recID, $_REQUEST['SelectedID']);

	return $recID;
}

function c001_copy_children($destination_id, $source_id) {
	global $Translation;
	$requests = []; // array of curl handlers for launching insert requests
	$eo = ['silentErrors' => true];
	$safe_sid = makeSafe($source_id);

	// launch requests, asynchronously
	curl_batch($requests);
}

function c001_delete($selected_id, $AllowDeleteOfParents = false, $skipChecks = false) {
	// insure referential integrity ...
	global $Translation;
	$selected_id = makeSafe($selected_id);

	// mm: can member delete record?
	if(!check_record_permission('c001', $selected_id, 'delete')) {
		return $Translation['You don\'t have enough permissions to delete this record'];
	}

	// hook: c001_before_delete
	if(function_exists('c001_before_delete')) {
		$args = [];
		if(!c001_before_delete($selected_id, $skipChecks, getMemberInfo(), $args))
			return $Translation['Couldn\'t delete this record'] . (
				!empty($args['error_message']) ?
					'<div class="text-bold">' . strip_tags($args['error_message']) . '</div>'
					: '' 
			);
	}

	// child table: c001_ref
	$res = sql("SELECT `id` FROM `c001` WHERE `id`='{$selected_id}'", $eo);
	$id = db_fetch_row($res);
	$rires = sql("SELECT COUNT(1) FROM `c001_ref` WHERE `id_categoria`='" . makeSafe($id[0]) . "'", $eo);
	$rirow = db_fetch_row($rires);
	if($rirow[0] && !$AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation["couldn't delete"];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'c001_ref', $RetMsg);
		return $RetMsg;
	} elseif($rirow[0] && $AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation['confirm delete'];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'c001_ref', $RetMsg);
		$RetMsg = str_replace('<Delete>', '<input type="button" class="button" value="' . $Translation['yes'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '&delete_x=1&confirmed=1\';">', $RetMsg);
		$RetMsg = str_replace('<Cancel>', '<input type="button" class="button" value="' . $Translation[ 'no'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '\';">', $RetMsg);
		return $RetMsg;
	}

	// child table: c001_ref_colaborar
	$res = sql("SELECT `id` FROM `c001` WHERE `id`='{$selected_id}'", $eo);
	$id = db_fetch_row($res);
	$rires = sql("SELECT COUNT(1) FROM `c001_ref_colaborar` WHERE `id_categoria`='" . makeSafe($id[0]) . "'", $eo);
	$rirow = db_fetch_row($rires);
	if($rirow[0] && !$AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation["couldn't delete"];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'c001_ref_colaborar', $RetMsg);
		return $RetMsg;
	} elseif($rirow[0] && $AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation['confirm delete'];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'c001_ref_colaborar', $RetMsg);
		$RetMsg = str_replace('<Delete>', '<input type="button" class="button" value="' . $Translation['yes'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '&delete_x=1&confirmed=1\';">', $RetMsg);
		$RetMsg = str_replace('<Cancel>', '<input type="button" class="button" value="' . $Translation[ 'no'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '\';">', $RetMsg);
		return $RetMsg;
	}

	// child table: c001_ref_inativas
	$res = sql("SELECT `id` FROM `c001` WHERE `id`='{$selected_id}'", $eo);
	$id = db_fetch_row($res);
	$rires = sql("SELECT COUNT(1) FROM `c001_ref_inativas` WHERE `id_categoria`='" . makeSafe($id[0]) . "'", $eo);
	$rirow = db_fetch_row($rires);
	if($rirow[0] && !$AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation["couldn't delete"];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'c001_ref_inativas', $RetMsg);
		return $RetMsg;
	} elseif($rirow[0] && $AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation['confirm delete'];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'c001_ref_inativas', $RetMsg);
		$RetMsg = str_replace('<Delete>', '<input type="button" class="button" value="' . $Translation['yes'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '&delete_x=1&confirmed=1\';">', $RetMsg);
		$RetMsg = str_replace('<Cancel>', '<input type="button" class="button" value="' . $Translation[ 'no'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '\';">', $RetMsg);
		return $RetMsg;
	}

	// child table: referencias_ativas
	$res = sql("SELECT `id` FROM `c001` WHERE `id`='{$selected_id}'", $eo);
	$id = db_fetch_row($res);
	$rires = sql("SELECT COUNT(1) FROM `referencias_ativas` WHERE `id_categoria`='" . makeSafe($id[0]) . "'", $eo);
	$rirow = db_fetch_row($rires);
	if($rirow[0] && !$AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation["couldn't delete"];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'referencias_ativas', $RetMsg);
		return $RetMsg;
	} elseif($rirow[0] && $AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation['confirm delete'];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'referencias_ativas', $RetMsg);
		$RetMsg = str_replace('<Delete>', '<input type="button" class="button" value="' . $Translation['yes'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '&delete_x=1&confirmed=1\';">', $RetMsg);
		$RetMsg = str_replace('<Cancel>', '<input type="button" class="button" value="' . $Translation[ 'no'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '\';">', $RetMsg);
		return $RetMsg;
	}

	// child table: referencias_inativas
	$res = sql("SELECT `id` FROM `c001` WHERE `id`='{$selected_id}'", $eo);
	$id = db_fetch_row($res);
	$rires = sql("SELECT COUNT(1) FROM `referencias_inativas` WHERE `id_categoria`='" . makeSafe($id[0]) . "'", $eo);
	$rirow = db_fetch_row($rires);
	if($rirow[0] && !$AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation["couldn't delete"];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'referencias_inativas', $RetMsg);
		return $RetMsg;
	} elseif($rirow[0] && $AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation['confirm delete'];
		$RetMsg = str_replace('<RelatedRecords>', $rirow[0], $RetMsg);
		$RetMsg = str_replace('<TableName>', 'referencias_inativas', $RetMsg);
		$RetMsg = str_replace('<Delete>', '<input type="button" class="button" value="' . $Translation['yes'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '&delete_x=1&confirmed=1\';">', $RetMsg);
		$RetMsg = str_replace('<Cancel>', '<input type="button" class="button" value="' . $Translation[ 'no'] . '" onClick="window.location = \'c001_view.php?SelectedID=' . urlencode($selected_id) . '\';">', $RetMsg);
		return $RetMsg;
	}

	sql("DELETE FROM `c001` WHERE `id`='{$selected_id}'", $eo);

	// hook: c001_after_delete
	if(function_exists('c001_after_delete')) {
		$args = [];
		c001_after_delete($selected_id, getMemberInfo(), $args);
	}

	// mm: delete ownership data
	sql("DELETE FROM `membership_userrecords` WHERE `tableName`='c001' AND `pkValue`='{$selected_id}'", $eo);
}

function c001_update(&$selected_id, &$error_message = '') {
	global $Translation;

	// mm: can member edit record?
	if(!check_record_permission('c001', $selected_id, 'edit')) return false;

	$data = [
		'cod_categoria' => Request::val('cod_categoria', ''),
		'categoria' => Request::val('categoria', ''),
		'atividade' => br2nl(Request::val('atividade', '')),
		'descricao' => br2nl(Request::val('descricao', '')),
		'quantidade' => Request::val('quantidade', ''),
		'unidade' => Request::lookup('unidade', ''),
		'uta' => Request::val('uta', ''),
		'valor' => Request::val('valor', ''),
	];

	if($data['atividade'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Atividade': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['descricao'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Descri&#231;&#227;o / Especifica&#231;&#227;o': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	// get existing values
	$old_data = getRecord('c001', $selected_id);
	if(is_array($old_data)) {
		$old_data = array_map('makeSafe', $old_data);
		$old_data['selectedID'] = makeSafe($selected_id);
	}

	$data['selectedID'] = makeSafe($selected_id);

	// hook: c001_before_update
	if(function_exists('c001_before_update')) {
		$args = ['old_data' => $old_data];
		if(!c001_before_update($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$set = $data; unset($set['selectedID']);
	foreach ($set as $field => $value) {
		$set[$field] = ($value !== '' && $value !== NULL) ? $value : NULL;
	}

	if(!update(
		'c001', 
		backtick_keys_once($set), 
		['`id`' => $selected_id], 
		$error_message
	)) {
		echo $error_message;
		echo '<a href="c001_view.php?SelectedID=' . urlencode($selected_id) . "\">{$Translation['< back']}</a>";
		exit;
	}


	$eo = ['silentErrors' => true];

	update_calc_fields('c001', $data['selectedID'], calculated_fields()['c001']);

	// hook: c001_after_update
	if(function_exists('c001_after_update')) {
		$res = sql("SELECT * FROM `c001` WHERE `id`='{$data['selectedID']}' LIMIT 1", $eo);
		if($row = db_fetch_assoc($res)) $data = array_map('makeSafe', $row);

		$data['selectedID'] = $data['id'];
		$args = ['old_data' => $old_data];
		if(!c001_after_update($data, getMemberInfo(), $args)) return;
	}

	// mm: update ownership data
	sql("UPDATE `membership_userrecords` SET `dateUpdated`='" . time() . "' WHERE `tableName`='c001' AND `pkValue`='" . makeSafe($selected_id) . "'", $eo);
}

function c001_form($selected_id = '', $AllowUpdate = 1, $AllowInsert = 1, $AllowDelete = 1, $ShowCancel = 0, $TemplateDV = '', $TemplateDVP = '') {
	// function to return an editable form for a table records
	// and fill it with data of record whose ID is $selected_id. If $selected_id
	// is empty, an empty form is shown, with only an 'Add New'
	// button displayed.

	global $Translation;

	// mm: get table permissions
	$arrPerm = getTablePermissions('c001');
	if(!$arrPerm['insert'] && $selected_id=='') return $Translation['tableAccessDenied'];
	$AllowInsert = ($arrPerm['insert'] ? true : false);
	// print preview?
	$dvprint = false;
	if($selected_id && $_REQUEST['dvprint_x'] != '') {
		$dvprint = true;
	}

	$filterer_unidade = thisOr($_REQUEST['filterer_unidade'], '');

	// populate filterers, starting from children to grand-parents

	// unique random identifier
	$rnd1 = ($dvprint ? rand(1000000, 9999999) : '');
	// combobox: unidade
	$combo_unidade = new DataCombo;

	if($selected_id) {
		// mm: check member permissions
		if(!$arrPerm['view']) return $Translation['tableAccessDenied'];

		// mm: who is the owner?
		$ownerGroupID = sqlValue("SELECT `groupID` FROM `membership_userrecords` WHERE `tableName`='c001' AND `pkValue`='" . makeSafe($selected_id) . "'");
		$ownerMemberID = sqlValue("SELECT LCASE(`memberID`) FROM `membership_userrecords` WHERE `tableName`='c001' AND `pkValue`='" . makeSafe($selected_id) . "'");

		if($arrPerm['view'] == 1 && getLoggedMemberID() != $ownerMemberID) return $Translation['tableAccessDenied'];
		if($arrPerm['view'] == 2 && getLoggedGroupID() != $ownerGroupID) return $Translation['tableAccessDenied'];

		// can edit?
		$AllowUpdate = 0;
		if(($arrPerm['edit'] == 1 && $ownerMemberID == getLoggedMemberID()) || ($arrPerm['edit'] == 2 && $ownerGroupID == getLoggedGroupID()) || $arrPerm['edit'] == 3) {
			$AllowUpdate = 1;
		}

		$res = sql("SELECT * FROM `c001` WHERE `id`='" . makeSafe($selected_id) . "'", $eo);
		if(!($row = db_fetch_array($res))) {
			return error_message($Translation['No records found'], 'c001_view.php', false);
		}
		$combo_unidade->SelectedData = $row['unidade'];
		$urow = $row; /* unsanitized data */
		$row = array_map('safe_html', $row);
	} else {
		$combo_unidade->SelectedData = $filterer_unidade;
	}
	$combo_unidade->HTML = '<span id="unidade-container' . $rnd1 . '"></span><input type="hidden" name="unidade" id="unidade' . $rnd1 . '" value="' . html_attr($combo_unidade->SelectedData) . '">';
	$combo_unidade->MatchText = '<span id="unidade-container-readonly' . $rnd1 . '"></span><input type="hidden" name="unidade" id="unidade' . $rnd1 . '" value="' . html_attr($combo_unidade->SelectedData) . '">';

	ob_start();
	?>

	<script>
		// initial lookup values
		AppGini.current_unidade__RAND__ = { text: "", value: "<?php echo addslashes($selected_id ? $urow['unidade'] : htmlspecialchars($filterer_unidade, ENT_QUOTES)); ?>"};

		jQuery(function() {
			setTimeout(function() {
				if(typeof(unidade_reload__RAND__) == 'function') unidade_reload__RAND__();
			}, 50); /* we need to slightly delay client-side execution of the above code to allow AppGini.ajaxCache to work */
		});
		function unidade_reload__RAND__() {
		<?php if(($AllowUpdate || $AllowInsert) && !$dvprint) { ?>

			$j("#unidade-container__RAND__").select2({
				/* initial default value */
				initSelection: function(e, c) {
					$j.ajax({
						url: 'ajax_combo.php',
						dataType: 'json',
						data: { id: AppGini.current_unidade__RAND__.value, t: 'c001', f: 'unidade' },
						success: function(resp) {
							c({
								id: resp.results[0].id,
								text: resp.results[0].text
							});
							$j('[name="unidade"]').val(resp.results[0].id);
							$j('[id=unidade-container-readonly__RAND__]').html('<span id="unidade-match-text">' + resp.results[0].text + '</span>');
							if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }


							if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
						}
					});
				},
				width: '100%',
				formatNoMatches: function(term) { return '<?php echo addslashes($Translation['No matches found!']); ?>'; },
				minimumResultsForSearch: 5,
				loadMorePadding: 200,
				ajax: {
					url: 'ajax_combo.php',
					dataType: 'json',
					cache: true,
					data: function(term, page) { return { s: term, p: page, t: 'c001', f: 'unidade' }; },
					results: function(resp, page) { return resp; }
				},
				escapeMarkup: function(str) { return str; }
			}).on('change', function(e) {
				AppGini.current_unidade__RAND__.value = e.added.id;
				AppGini.current_unidade__RAND__.text = e.added.text;
				$j('[name="unidade"]').val(e.added.id);
				if(e.added.id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }


				if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
			});

			if(!$j("#unidade-container__RAND__").length) {
				$j.ajax({
					url: 'ajax_combo.php',
					dataType: 'json',
					data: { id: AppGini.current_unidade__RAND__.value, t: 'c001', f: 'unidade' },
					success: function(resp) {
						$j('[name="unidade"]').val(resp.results[0].id);
						$j('[id=unidade-container-readonly__RAND__]').html('<span id="unidade-match-text">' + resp.results[0].text + '</span>');
						if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }

						if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
					}
				});
			}

		<?php } else { ?>

			$j.ajax({
				url: 'ajax_combo.php',
				dataType: 'json',
				data: { id: AppGini.current_unidade__RAND__.value, t: 'c001', f: 'unidade' },
				success: function(resp) {
					$j('[id=unidade-container__RAND__], [id=unidade-container-readonly__RAND__]').html('<span id="unidade-match-text">' + resp.results[0].text + '</span>');
					if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }

					if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
				}
			});
		<?php } ?>

		}
	</script>
	<?php

	$lookups = str_replace('__RAND__', $rnd1, ob_get_contents());
	ob_end_clean();


	// code for template based detail view forms

	// open the detail view template
	if($dvprint) {
		$template_file = is_file("./{$TemplateDVP}") ? "./{$TemplateDVP}" : './templates/c001_templateDVP.html';
		$templateCode = @file_get_contents($template_file);
	} else {
		$template_file = is_file("./{$TemplateDV}") ? "./{$TemplateDV}" : './templates/c001_templateDV.html';
		$templateCode = @file_get_contents($template_file);
	}

	// process form title
	$templateCode = str_replace('<%%DETAIL_VIEW_TITLE%%>', 'Detalhes', $templateCode);
	$templateCode = str_replace('<%%RND1%%>', $rnd1, $templateCode);
	$templateCode = str_replace('<%%EMBEDDED%%>', ($_REQUEST['Embedded'] ? 'Embedded=1' : ''), $templateCode);
	// process buttons
	if($AllowInsert) {
		if(!$selected_id) $templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-success" id="insert" name="insert_x" value="1" onclick="return c001_validateData();"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save New'] . '</button>', $templateCode);
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="insert" name="insert_x" value="1" onclick="return c001_validateData();"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save As Copy'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '', $templateCode);
	}

	// 'Back' button action
	if($_REQUEST['Embedded']) {
		$backAction = 'AppGini.closeParentModal(); return false;';
	} else {
		$backAction = '$j(\'form\').eq(0).attr(\'novalidate\', \'novalidate\'); document.myform.reset(); return true;';
	}

	if($selected_id) {
		if(!$_REQUEST['Embedded']) $templateCode = str_replace('<%%DVPRINT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="dvprint" name="dvprint_x" value="1" onclick="$j(\'form\').eq(0).prop(\'novalidate\', true); document.myform.reset(); return true;" title="' . html_attr($Translation['Print Preview']) . '"><i class="glyphicon glyphicon-print"></i> ' . $Translation['Print Preview'] . '</button>', $templateCode);
		if($AllowUpdate) {
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '<button type="submit" class="btn btn-success btn-lg" id="update" name="update_x" value="1" onclick="return c001_validateData();" title="' . html_attr($Translation['Save Changes']) . '"><i class="glyphicon glyphicon-ok"></i> ' . $Translation['Save Changes'] . '</button>', $templateCode);
		} else {
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		}
		if(($arrPerm[4]==1 && $ownerMemberID==getLoggedMemberID()) || ($arrPerm[4]==2 && $ownerGroupID==getLoggedGroupID()) || $arrPerm[4]==3) { // allow delete?
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '<button type="submit" class="btn btn-danger" id="delete" name="delete_x" value="1" onclick="return confirm(\'' . $Translation['are you sure?'] . '\');" title="' . html_attr($Translation['Delete']) . '"><i class="glyphicon glyphicon-trash"></i> ' . $Translation['Delete'] . '</button>', $templateCode);
		} else {
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);
		}
		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', ($ShowCancel ? '<button type="submit" class="btn btn-default" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>' : ''), $templateCode);
	}

	// set records to read only if user can't insert new records and can't edit current record
	if(($selected_id && !$AllowUpdate && !$AllowInsert) || (!$selected_id && !$AllowInsert)) {
		$jsReadOnly = '';
		$jsReadOnly .= "\tjQuery('#categoria').replaceWith('<div class=\"form-control-static\" id=\"categoria\">' + (jQuery('#categoria').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#atividade').replaceWith('<div class=\"form-control-static\" id=\"atividade\">' + (jQuery('#atividade').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#descricao').replaceWith('<div class=\"form-control-static\" id=\"descricao\">' + (jQuery('#descricao').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('.select2-container').hide();\n";

		$noUploads = true;
	} elseif($AllowInsert) {
		$jsEditable = "\tjQuery('form').eq(0).data('already_changed', true);"; // temporarily disable form change handler
		$jsEditable .= "\tjQuery('form').eq(0).data('already_changed', false);"; // re-enable form change handler
	}

	// process combos
	$templateCode = str_replace('<%%COMBO(unidade)%%>', $combo_unidade->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(unidade)%%>', $combo_unidade->MatchText, $templateCode);
	$templateCode = str_replace('<%%URLCOMBOTEXT(unidade)%%>', urlencode($combo_unidade->MatchText), $templateCode);

	/* lookup fields array: 'lookup field name' => array('parent table name', 'lookup field caption') */
	$lookup_fields = array('unidade' => array('unidades', 'Unidade'), );
	foreach($lookup_fields as $luf => $ptfc) {
		$pt_perm = getTablePermissions($ptfc[0]);

		// process foreign key links
		if($pt_perm['view'] || $pt_perm['edit']) {
			$templateCode = str_replace("<%%PLINK({$luf})%%>", '<button type="button" class="btn btn-default view_parent hspacer-md" id="' . $ptfc[0] . '_view_parent" title="' . html_attr($Translation['View'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-eye-open"></i></button>', $templateCode);
		}

		// if user has insert permission to parent table of a lookup field, put an add new button
		if($pt_perm['insert'] /* && !$_REQUEST['Embedded']*/) {
			$templateCode = str_replace("<%%ADDNEW({$ptfc[0]})%%>", '<button type="button" class="btn btn-success add_new_parent hspacer-md" id="' . $ptfc[0] . '_add_new" title="' . html_attr($Translation['Add New'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-plus-sign"></i></button>', $templateCode);
		}
	}

	// process images
	$templateCode = str_replace('<%%UPLOADFILE(id)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(cod_categoria)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(categoria)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(atividade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(descricao)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(quantidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(unidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(uta)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(valor)%%>', '', $templateCode);

	// process values
	if($selected_id) {
		if( $dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', safe_html($urow['id']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', html_attr($row['id']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode($urow['id']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(cod_categoria)%%>', safe_html($urow['cod_categoria']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(cod_categoria)%%>', html_attr($row['cod_categoria']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cod_categoria)%%>', urlencode($urow['cod_categoria']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(categoria)%%>', safe_html($urow['categoria']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(categoria)%%>', html_attr($row['categoria']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(categoria)%%>', urlencode($urow['categoria']), $templateCode);
		if($dvprint || (!$AllowUpdate && !$AllowInsert)) {
			$templateCode = str_replace('<%%VALUE(atividade)%%>', safe_html($urow['atividade']), $templateCode);
		} else {
			$templateCode = str_replace('<%%VALUE(atividade)%%>', safe_html($urow['atividade'], true), $templateCode);
		}
		$templateCode = str_replace('<%%URLVALUE(atividade)%%>', urlencode($urow['atividade']), $templateCode);
		if($dvprint || (!$AllowUpdate && !$AllowInsert)) {
			$templateCode = str_replace('<%%VALUE(descricao)%%>', safe_html($urow['descricao']), $templateCode);
		} else {
			$templateCode = str_replace('<%%VALUE(descricao)%%>', safe_html($urow['descricao'], true), $templateCode);
		}
		$templateCode = str_replace('<%%URLVALUE(descricao)%%>', urlencode($urow['descricao']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(quantidade)%%>', safe_html($urow['quantidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(quantidade)%%>', html_attr($row['quantidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(quantidade)%%>', urlencode($urow['quantidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(unidade)%%>', safe_html($urow['unidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(unidade)%%>', html_attr($row['unidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unidade)%%>', urlencode($urow['unidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(uta)%%>', safe_html($urow['uta']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(uta)%%>', html_attr($row['uta']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uta)%%>', urlencode($urow['uta']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(valor)%%>', safe_html($urow['valor']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(valor)%%>', html_attr($row['valor']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(valor)%%>', urlencode($urow['valor']), $templateCode);
	} else {
		$templateCode = str_replace('<%%VALUE(id)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(cod_categoria)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cod_categoria)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(categoria)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(categoria)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(atividade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(atividade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(descricao)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(descricao)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(quantidade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(quantidade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(unidade)%%>', ( $_REQUEST['FilterField'][1]=='7' && $_REQUEST['FilterOperator'][1]=='<=>' ? $combo_unidade->SelectedData : ''), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unidade)%%>', urlencode( $_REQUEST['FilterField'][1]=='7' && $_REQUEST['FilterOperator'][1]=='<=>' ? $combo_unidade->SelectedData : ''), $templateCode);
		$templateCode = str_replace('<%%VALUE(uta)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uta)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(valor)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(valor)%%>', urlencode(''), $templateCode);
	}

	// process translations
	$templateCode = parseTemplate($templateCode);

	// clear scrap
	$templateCode = str_replace('<%%', '<!-- ', $templateCode);
	$templateCode = str_replace('%%>', ' -->', $templateCode);

	// hide links to inaccessible tables
	if($_REQUEST['dvprint_x'] == '') {
		$templateCode .= "\n\n<script>\$j(function() {\n";
		$arrTables = getTableList();
		foreach($arrTables as $name => $caption) {
			$templateCode .= "\t\$j('#{$name}_link').removeClass('hidden');\n";
			$templateCode .= "\t\$j('#xs_{$name}_link').removeClass('hidden');\n";
		}

		$templateCode .= $jsReadOnly;
		$templateCode .= $jsEditable;

		if(!$selected_id) {
		}

		$templateCode.="\n});</script>\n";
	}

	// ajaxed auto-fill fields
	$templateCode .= '<script>';
	$templateCode .= '$j(function() {';


	$templateCode.="});";
	$templateCode.="</script>";
	$templateCode .= $lookups;

	// handle enforced parent values for read-only lookup fields

	// don't include blank images in lightbox gallery
	$templateCode = preg_replace('/blank.gif" data-lightbox=".*?"/', 'blank.gif"', $templateCode);

	// don't display empty email links
	$templateCode=preg_replace('/<a .*?href="mailto:".*?<\/a>/', '', $templateCode);

	/* default field values */
	$rdata = $jdata = get_defaults('c001');
	if($selected_id) {
		$jdata = get_joined_record('c001', $selected_id);
		if($jdata === false) $jdata = get_defaults('c001');
		$rdata = $row;
	}
	$templateCode .= loadView('c001-ajax-cache', array('rdata' => $rdata, 'jdata' => $jdata));

	// hook: c001_dv
	if(function_exists('c001_dv')) {
		$args=[];
		c001_dv(($selected_id ? $selected_id : FALSE), getMemberInfo(), $templateCode, $args);
	}

	return $templateCode;
}