<?php

// Data functions (insert, update, delete, form) for table c001_ref

// This script and data application were generated by AppGini 5.97
// Download AppGini for free from https://bigprof.com/appgini/download/

function c001_ref_insert(&$error_message = '') {
	global $Translation;

	// mm: can member insert record?
	$arrPerm = getTablePermissions('c001_ref');
	if(!$arrPerm['insert']) return false;

	$data = [
		'id_categoria' => Request::lookup('id_categoria', ''),
		'data' => parseCode('<%%creationDateTime%%>', true, true),
		'nome' => Request::val('nome', ''),
		'cpf' => Request::val('cpf', ''),
		'celular' => Request::val('celular', ''),
		'email' => Request::val('email', ''),
		'cidade' => Request::val('cidade', ''),
		'uf' => Request::val('uf', ''),
		'regiao' => Request::val('regiao', ''),
		'quantidade' => Request::val('quantidade', ''),
		'unidade' => Request::val('unidade', ''),
		'uta' => Request::val('uta', ''),
		'valor' => Request::val('valor', ''),
		'obs' => br2nl(Request::val('obs', '')),
		'situacao' => Request::val('situacao', 'INATIVA'),
	];


	// hook: c001_ref_before_insert
	if(function_exists('c001_ref_before_insert')) {
		$args = [];
		if(!c001_ref_before_insert($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$error = '';
	// set empty fields to NULL
	$data = array_map(function($v) { return ($v === '' ? NULL : $v); }, $data);
	insert('c001_ref', backtick_keys_once($data), $error);
	if($error)
		die("{$error}<br><a href=\"#\" onclick=\"history.go(-1);\">{$Translation['< back']}</a>");

	$recID = db_insert_id(db_link());

	// automatic id_categoria if passed as filterer
	if($_REQUEST['filterer_id_categoria']) {
		sql("UPDATE `c001_ref` SET `id_categoria`='" . makeSafe($_REQUEST['filterer_id_categoria']) . "' WHERE `id`='" . makeSafe($recID, false) . "'", $eo);
	}

	update_calc_fields('c001_ref', $recID, calculated_fields()['c001_ref']);

	// hook: c001_ref_after_insert
	if(function_exists('c001_ref_after_insert')) {
		$res = sql("SELECT * FROM `c001_ref` WHERE `id`='" . makeSafe($recID, false) . "' LIMIT 1", $eo);
		if($row = db_fetch_assoc($res)) {
			$data = array_map('makeSafe', $row);
		}
		$data['selectedID'] = makeSafe($recID, false);
		$args=[];
		if(!c001_ref_after_insert($data, getMemberInfo(), $args)) { return $recID; }
	}

	// mm: save ownership data
	set_record_owner('c001_ref', $recID, getLoggedMemberID());

	// if this record is a copy of another record, copy children if applicable
	if(!empty($_REQUEST['SelectedID'])) c001_ref_copy_children($recID, $_REQUEST['SelectedID']);

	return $recID;
}

function c001_ref_copy_children($destination_id, $source_id) {
	global $Translation;
	$requests = []; // array of curl handlers for launching insert requests
	$eo = ['silentErrors' => true];
	$safe_sid = makeSafe($source_id);

	// launch requests, asynchronously
	curl_batch($requests);
}

function c001_ref_delete($selected_id, $AllowDeleteOfParents = false, $skipChecks = false) {
	// insure referential integrity ...
	global $Translation;
	$selected_id = makeSafe($selected_id);

	// mm: can member delete record?
	if(!check_record_permission('c001_ref', $selected_id, 'delete')) {
		return $Translation['You don\'t have enough permissions to delete this record'];
	}

	// hook: c001_ref_before_delete
	if(function_exists('c001_ref_before_delete')) {
		$args = [];
		if(!c001_ref_before_delete($selected_id, $skipChecks, getMemberInfo(), $args))
			return $Translation['Couldn\'t delete this record'] . (
				!empty($args['error_message']) ?
					'<div class="text-bold">' . strip_tags($args['error_message']) . '</div>'
					: '' 
			);
	}

	sql("DELETE FROM `c001_ref` WHERE `id`='{$selected_id}'", $eo);

	// hook: c001_ref_after_delete
	if(function_exists('c001_ref_after_delete')) {
		$args = [];
		c001_ref_after_delete($selected_id, getMemberInfo(), $args);
	}

	// mm: delete ownership data
	sql("DELETE FROM `membership_userrecords` WHERE `tableName`='c001_ref' AND `pkValue`='{$selected_id}'", $eo);
}

function c001_ref_update(&$selected_id, &$error_message = '') {
	global $Translation;

	// mm: can member edit record?
	if(!check_record_permission('c001_ref', $selected_id, 'edit')) return false;

	$data = [
		'id_categoria' => Request::lookup('id_categoria', ''),
		'nome' => Request::val('nome', ''),
		'cpf' => Request::val('cpf', ''),
		'celular' => Request::val('celular', ''),
		'email' => Request::val('email', ''),
		'cidade' => Request::val('cidade', ''),
		'uf' => Request::val('uf', ''),
		'regiao' => Request::val('regiao', ''),
		'quantidade' => Request::val('quantidade', ''),
		'unidade' => Request::val('unidade', ''),
		'uta' => Request::val('uta', ''),
		'valor' => Request::val('valor', ''),
		'obs' => br2nl(Request::val('obs', '')),
		'situacao' => Request::val('situacao', ''),
	];

	// get existing values
	$old_data = getRecord('c001_ref', $selected_id);
	if(is_array($old_data)) {
		$old_data = array_map('makeSafe', $old_data);
		$old_data['selectedID'] = makeSafe($selected_id);
	}

	$data['selectedID'] = makeSafe($selected_id);

	// hook: c001_ref_before_update
	if(function_exists('c001_ref_before_update')) {
		$args = ['old_data' => $old_data];
		if(!c001_ref_before_update($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$set = $data; unset($set['selectedID']);
	foreach ($set as $field => $value) {
		$set[$field] = ($value !== '' && $value !== NULL) ? $value : NULL;
	}

	if(!update(
		'c001_ref', 
		backtick_keys_once($set), 
		['`id`' => $selected_id], 
		$error_message
	)) {
		echo $error_message;
		echo '<a href="c001_ref_view.php?SelectedID=' . urlencode($selected_id) . "\">{$Translation['< back']}</a>";
		exit;
	}


	$eo = ['silentErrors' => true];

	update_calc_fields('c001_ref', $data['selectedID'], calculated_fields()['c001_ref']);

	// hook: c001_ref_after_update
	if(function_exists('c001_ref_after_update')) {
		$res = sql("SELECT * FROM `c001_ref` WHERE `id`='{$data['selectedID']}' LIMIT 1", $eo);
		if($row = db_fetch_assoc($res)) $data = array_map('makeSafe', $row);

		$data['selectedID'] = $data['id'];
		$args = ['old_data' => $old_data];
		if(!c001_ref_after_update($data, getMemberInfo(), $args)) return;
	}

	// mm: update ownership data
	sql("UPDATE `membership_userrecords` SET `dateUpdated`='" . time() . "' WHERE `tableName`='c001_ref' AND `pkValue`='" . makeSafe($selected_id) . "'", $eo);
}

function c001_ref_form($selected_id = '', $AllowUpdate = 1, $AllowInsert = 1, $AllowDelete = 1, $ShowCancel = 0, $TemplateDV = '', $TemplateDVP = '') {
	// function to return an editable form for a table records
	// and fill it with data of record whose ID is $selected_id. If $selected_id
	// is empty, an empty form is shown, with only an 'Add New'
	// button displayed.

	global $Translation;

	// mm: get table permissions
	$arrPerm = getTablePermissions('c001_ref');
	if(!$arrPerm['insert'] && $selected_id=='') return $Translation['tableAccessDenied'];
	$AllowInsert = ($arrPerm['insert'] ? true : false);
	// print preview?
	$dvprint = false;
	if($selected_id && $_REQUEST['dvprint_x'] != '') {
		$dvprint = true;
	}

	$filterer_id_categoria = thisOr($_REQUEST['filterer_id_categoria'], '');

	// populate filterers, starting from children to grand-parents

	// unique random identifier
	$rnd1 = ($dvprint ? rand(1000000, 9999999) : '');
	// combobox: id_categoria
	$combo_id_categoria = new DataCombo;
	// combobox: data
	$combo_data = new DateCombo;
	$combo_data->DateFormat = "dmy";
	$combo_data->MinYear = 1900;
	$combo_data->MaxYear = 2100;
	$combo_data->DefaultDate = parseMySQLDate('<%%creationDateTime%%>', '<%%creationDateTime%%>');
	$combo_data->MonthNames = $Translation['month names'];
	$combo_data->NamePrefix = 'data';
	// combobox: uf
	$combo_uf = new Combo;
	$combo_uf->ListType = 0;
	$combo_uf->MultipleSeparator = ', ';
	$combo_uf->ListBoxHeight = 10;
	$combo_uf->RadiosPerLine = 1;
	if(is_file(dirname(__FILE__).'/hooks/c001_ref.uf.csv')) {
		$uf_data = addslashes(implode('', @file(dirname(__FILE__).'/hooks/c001_ref.uf.csv')));
		$combo_uf->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions($uf_data)));
		$combo_uf->ListData = $combo_uf->ListItem;
	} else {
		$combo_uf->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions(";;AC;;AL;;AP;;AM;;BA;;CE;;DF;;ES;;GO;;MA;;MT;;MS;;MG;;PR;;PB;;PA;;PE;;PI;;RJ;;RN;;RS;;RO;;RR;;SC;;SE;;SP;;TO ")));
		$combo_uf->ListData = $combo_uf->ListItem;
	}
	$combo_uf->SelectName = 'uf';
	// combobox: regiao
	$combo_regiao = new Combo;
	$combo_regiao->ListType = 0;
	$combo_regiao->MultipleSeparator = ', ';
	$combo_regiao->ListBoxHeight = 10;
	$combo_regiao->RadiosPerLine = 1;
	if(is_file(dirname(__FILE__).'/hooks/c001_ref.regiao.csv')) {
		$regiao_data = addslashes(implode('', @file(dirname(__FILE__).'/hooks/c001_ref.regiao.csv')));
		$combo_regiao->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions($regiao_data)));
		$combo_regiao->ListData = $combo_regiao->ListItem;
	} else {
		$combo_regiao->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions(";;AC;;AL;;AP;;AM;;BA;;CE;;DF;;ES;;GO;;MA;;MT;;MS;;MG;;PR;;PB;;PA;;PE;;PI;;RJ;;RN;;RS;;RO;;RR;;SC;;SE;;SP;;TO ")));
		$combo_regiao->ListData = $combo_regiao->ListItem;
	}
	$combo_regiao->SelectName = 'regiao';
	// combobox: situacao
	$combo_situacao = new Combo;
	$combo_situacao->ListType = 0;
	$combo_situacao->MultipleSeparator = ', ';
	$combo_situacao->ListBoxHeight = 10;
	$combo_situacao->RadiosPerLine = 1;
	if(is_file(dirname(__FILE__).'/hooks/c001_ref.situacao.csv')) {
		$situacao_data = addslashes(implode('', @file(dirname(__FILE__).'/hooks/c001_ref.situacao.csv')));
		$combo_situacao->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions($situacao_data)));
		$combo_situacao->ListData = $combo_situacao->ListItem;
	} else {
		$combo_situacao->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions("ATIVA;;INATIVA")));
		$combo_situacao->ListData = $combo_situacao->ListItem;
	}
	$combo_situacao->SelectName = 'situacao';

	if($selected_id) {
		// mm: check member permissions
		if(!$arrPerm['view']) return $Translation['tableAccessDenied'];

		// mm: who is the owner?
		$ownerGroupID = sqlValue("SELECT `groupID` FROM `membership_userrecords` WHERE `tableName`='c001_ref' AND `pkValue`='" . makeSafe($selected_id) . "'");
		$ownerMemberID = sqlValue("SELECT LCASE(`memberID`) FROM `membership_userrecords` WHERE `tableName`='c001_ref' AND `pkValue`='" . makeSafe($selected_id) . "'");

		if($arrPerm['view'] == 1 && getLoggedMemberID() != $ownerMemberID) return $Translation['tableAccessDenied'];
		if($arrPerm['view'] == 2 && getLoggedGroupID() != $ownerGroupID) return $Translation['tableAccessDenied'];

		// can edit?
		$AllowUpdate = 0;
		if(($arrPerm['edit'] == 1 && $ownerMemberID == getLoggedMemberID()) || ($arrPerm['edit'] == 2 && $ownerGroupID == getLoggedGroupID()) || $arrPerm['edit'] == 3) {
			$AllowUpdate = 1;
		}

		$res = sql("SELECT * FROM `c001_ref` WHERE `id`='" . makeSafe($selected_id) . "'", $eo);
		if(!($row = db_fetch_array($res))) {
			return error_message($Translation['No records found'], 'c001_ref_view.php', false);
		}
		$combo_id_categoria->SelectedData = $row['id_categoria'];
		$row['data'] = sqlValue("SELECT DATE_FORMAT(`data`, '%e/%c/%Y') FROM `c001_ref` WHERE `id`='" . makeSafe($selected_id) . "'");
		$combo_uf->SelectedData = $row['uf'];
		$combo_regiao->SelectedData = $row['regiao'];
		$combo_situacao->SelectedData = $row['situacao'];
		$urow = $row; /* unsanitized data */
		$row = array_map('safe_html', $row);
	} else {
		$combo_id_categoria->SelectedData = $filterer_id_categoria;
		$combo_uf->SelectedText = ( $_REQUEST['FilterField'][1] == '9' && $_REQUEST['FilterOperator'][1] == '<=>' ? $_REQUEST['FilterValue'][1] : '');
		$combo_regiao->SelectedText = ( $_REQUEST['FilterField'][1] == '10' && $_REQUEST['FilterOperator'][1] == '<=>' ? $_REQUEST['FilterValue'][1] : '');
		$combo_situacao->SelectedText = ( $_REQUEST['FilterField'][1] == '16' && $_REQUEST['FilterOperator'][1] == '<=>' ? $_REQUEST['FilterValue'][1] : 'INATIVA');
	}
	$combo_id_categoria->HTML = '<span id="id_categoria-container' . $rnd1 . '"></span><input type="hidden" name="id_categoria" id="id_categoria' . $rnd1 . '" value="' . html_attr($combo_id_categoria->SelectedData) . '">';
	$combo_id_categoria->MatchText = '<span id="id_categoria-container-readonly' . $rnd1 . '"></span><input type="hidden" name="id_categoria" id="id_categoria' . $rnd1 . '" value="' . html_attr($combo_id_categoria->SelectedData) . '">';
	$combo_uf->Render();
	$combo_regiao->Render();
	$combo_situacao->Render();

	ob_start();
	?>

	<script>
		// initial lookup values
		AppGini.current_id_categoria__RAND__ = { text: "", value: "<?php echo addslashes($selected_id ? $urow['id_categoria'] : htmlspecialchars($filterer_id_categoria, ENT_QUOTES)); ?>"};

		jQuery(function() {
			setTimeout(function() {
				if(typeof(id_categoria_reload__RAND__) == 'function') id_categoria_reload__RAND__();
			}, 50); /* we need to slightly delay client-side execution of the above code to allow AppGini.ajaxCache to work */
		});
		function id_categoria_reload__RAND__() {
		<?php if(($AllowUpdate || $AllowInsert) && !$dvprint) { ?>

			$j("#id_categoria-container__RAND__").select2({
				/* initial default value */
				initSelection: function(e, c) {
					$j.ajax({
						url: 'ajax_combo.php',
						dataType: 'json',
						data: { id: AppGini.current_id_categoria__RAND__.value, t: 'c001_ref', f: 'id_categoria' },
						success: function(resp) {
							c({
								id: resp.results[0].id,
								text: resp.results[0].text
							});
							$j('[name="id_categoria"]').val(resp.results[0].id);
							$j('[id=id_categoria-container-readonly__RAND__]').html('<span id="id_categoria-match-text">' + resp.results[0].text + '</span>');
							if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=c001_view_parent]').hide(); } else { $j('.btn[id=c001_view_parent]').show(); }


							if(typeof(id_categoria_update_autofills__RAND__) == 'function') id_categoria_update_autofills__RAND__();
						}
					});
				},
				width: '100%',
				formatNoMatches: function(term) { return '<?php echo addslashes($Translation['No matches found!']); ?>'; },
				minimumResultsForSearch: 5,
				loadMorePadding: 200,
				ajax: {
					url: 'ajax_combo.php',
					dataType: 'json',
					cache: true,
					data: function(term, page) { return { s: term, p: page, t: 'c001_ref', f: 'id_categoria' }; },
					results: function(resp, page) { return resp; }
				},
				escapeMarkup: function(str) { return str; }
			}).on('change', function(e) {
				AppGini.current_id_categoria__RAND__.value = e.added.id;
				AppGini.current_id_categoria__RAND__.text = e.added.text;
				$j('[name="id_categoria"]').val(e.added.id);
				if(e.added.id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=c001_view_parent]').hide(); } else { $j('.btn[id=c001_view_parent]').show(); }


				if(typeof(id_categoria_update_autofills__RAND__) == 'function') id_categoria_update_autofills__RAND__();
			});

			if(!$j("#id_categoria-container__RAND__").length) {
				$j.ajax({
					url: 'ajax_combo.php',
					dataType: 'json',
					data: { id: AppGini.current_id_categoria__RAND__.value, t: 'c001_ref', f: 'id_categoria' },
					success: function(resp) {
						$j('[name="id_categoria"]').val(resp.results[0].id);
						$j('[id=id_categoria-container-readonly__RAND__]').html('<span id="id_categoria-match-text">' + resp.results[0].text + '</span>');
						if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=c001_view_parent]').hide(); } else { $j('.btn[id=c001_view_parent]').show(); }

						if(typeof(id_categoria_update_autofills__RAND__) == 'function') id_categoria_update_autofills__RAND__();
					}
				});
			}

		<?php } else { ?>

			$j.ajax({
				url: 'ajax_combo.php',
				dataType: 'json',
				data: { id: AppGini.current_id_categoria__RAND__.value, t: 'c001_ref', f: 'id_categoria' },
				success: function(resp) {
					$j('[id=id_categoria-container__RAND__], [id=id_categoria-container-readonly__RAND__]').html('<span id="id_categoria-match-text">' + resp.results[0].text + '</span>');
					if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=c001_view_parent]').hide(); } else { $j('.btn[id=c001_view_parent]').show(); }

					if(typeof(id_categoria_update_autofills__RAND__) == 'function') id_categoria_update_autofills__RAND__();
				}
			});
		<?php } ?>

		}
	</script>
	<?php

	$lookups = str_replace('__RAND__', $rnd1, ob_get_contents());
	ob_end_clean();


	// code for template based detail view forms

	// open the detail view template
	if($dvprint) {
		$template_file = is_file("./{$TemplateDVP}") ? "./{$TemplateDVP}" : './templates/c001_ref_templateDVP.html';
		$templateCode = @file_get_contents($template_file);
	} else {
		$template_file = is_file("./{$TemplateDV}") ? "./{$TemplateDV}" : './templates/c001_ref_templateDV.html';
		$templateCode = @file_get_contents($template_file);
	}

	// process form title
	$templateCode = str_replace('<%%DETAIL_VIEW_TITLE%%>', 'Refer&#234;ncias', $templateCode);
	$templateCode = str_replace('<%%RND1%%>', $rnd1, $templateCode);
	$templateCode = str_replace('<%%EMBEDDED%%>', ($_REQUEST['Embedded'] ? 'Embedded=1' : ''), $templateCode);
	// process buttons
	if($arrPerm[1] && !$selected_id) { // allow insert and no record selected?
		if(!$selected_id) $templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-success" id="insert" name="insert_x" value="1" onclick="return c001_ref_validateData();"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save New'] . '</button>', $templateCode);
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="insert" name="insert_x" value="1" onclick="return c001_ref_validateData();"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save As Copy'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '', $templateCode);
	}

	// 'Back' button action
	if($_REQUEST['Embedded']) {
		$backAction = 'AppGini.closeParentModal(); return false;';
	} else {
		$backAction = '$j(\'form\').eq(0).attr(\'novalidate\', \'novalidate\'); document.myform.reset(); return true;';
	}

	if($selected_id) {
		if(!$_REQUEST['Embedded']) $templateCode = str_replace('<%%DVPRINT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="dvprint" name="dvprint_x" value="1" onclick="$j(\'form\').eq(0).prop(\'novalidate\', true); document.myform.reset(); return true;" title="' . html_attr($Translation['Print Preview']) . '"><i class="glyphicon glyphicon-print"></i> ' . $Translation['Print Preview'] . '</button>', $templateCode);
		if($AllowUpdate) {
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '<button type="submit" class="btn btn-success btn-lg" id="update" name="update_x" value="1" onclick="return c001_ref_validateData();" title="' . html_attr($Translation['Save Changes']) . '"><i class="glyphicon glyphicon-ok"></i> ' . $Translation['Save Changes'] . '</button>', $templateCode);
		} else {
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		}
		if(($arrPerm[4]==1 && $ownerMemberID==getLoggedMemberID()) || ($arrPerm[4]==2 && $ownerGroupID==getLoggedGroupID()) || $arrPerm[4]==3) { // allow delete?
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '<button type="submit" class="btn btn-danger" id="delete" name="delete_x" value="1" onclick="return confirm(\'' . $Translation['are you sure?'] . '\');" title="' . html_attr($Translation['Delete']) . '"><i class="glyphicon glyphicon-trash"></i> ' . $Translation['Delete'] . '</button>', $templateCode);
		} else {
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);
		}
		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', ($ShowCancel ? '<button type="submit" class="btn btn-default" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>' : ''), $templateCode);
	}

	// set records to read only if user can't insert new records and can't edit current record
	if(($selected_id && !$AllowUpdate) || (!$selected_id && !$AllowInsert)) {
		$jsReadOnly = '';
		$jsReadOnly .= "\tjQuery('#regiao').replaceWith('<div class=\"form-control-static\" id=\"regiao\">' + (jQuery('#regiao').val() || '') + '</div>'); jQuery('#regiao-multi-selection-help').hide();\n";
		$jsReadOnly .= "\tjQuery('#quantidade').replaceWith('<div class=\"form-control-static\" id=\"quantidade\">' + (jQuery('#quantidade').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#unidade').replaceWith('<div class=\"form-control-static\" id=\"unidade\">' + (jQuery('#unidade').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#uta').replaceWith('<div class=\"form-control-static\" id=\"uta\">' + (jQuery('#uta').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#valor').replaceWith('<div class=\"form-control-static\" id=\"valor\">' + (jQuery('#valor').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('.select2-container').hide();\n";

		$noUploads = true;
	} elseif(($AllowInsert && !$selected_id) || ($AllowUpdate && $selected_id)) {
		$jsEditable = "\tjQuery('form').eq(0).data('already_changed', true);"; // temporarily disable form change handler
		$jsEditable .= "\tjQuery('form').eq(0).data('already_changed', false);"; // re-enable form change handler
	}

	// process combos
	$templateCode = str_replace('<%%COMBO(id_categoria)%%>', $combo_id_categoria->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(id_categoria)%%>', $combo_id_categoria->MatchText, $templateCode);
	$templateCode = str_replace('<%%URLCOMBOTEXT(id_categoria)%%>', urlencode($combo_id_categoria->MatchText), $templateCode);
	$templateCode = str_replace('<%%COMBO(data)%%>', ($selected_id && !$arrPerm[3] ? '<div class="form-control-static">' . $combo_data->GetHTML(true) . '</div>' : $combo_data->GetHTML()), $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(data)%%>', $combo_data->GetHTML(true), $templateCode);
	$templateCode = str_replace('<%%COMBO(uf)%%>', $combo_uf->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(uf)%%>', $combo_uf->SelectedData, $templateCode);
	$templateCode = str_replace('<%%COMBO(regiao)%%>', $combo_regiao->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(regiao)%%>', $combo_regiao->SelectedData, $templateCode);
	$templateCode = str_replace('<%%COMBO(situacao)%%>', $combo_situacao->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(situacao)%%>', $combo_situacao->SelectedData, $templateCode);

	/* lookup fields array: 'lookup field name' => array('parent table name', 'lookup field caption') */
	$lookup_fields = array('id_categoria' => array('c001', 'Id categoria'), );
	foreach($lookup_fields as $luf => $ptfc) {
		$pt_perm = getTablePermissions($ptfc[0]);

		// process foreign key links
		if($pt_perm['view'] || $pt_perm['edit']) {
			$templateCode = str_replace("<%%PLINK({$luf})%%>", '<button type="button" class="btn btn-default view_parent hspacer-md" id="' . $ptfc[0] . '_view_parent" title="' . html_attr($Translation['View'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-eye-open"></i></button>', $templateCode);
		}

		// if user has insert permission to parent table of a lookup field, put an add new button
		if($pt_perm['insert'] /* && !$_REQUEST['Embedded']*/) {
			$templateCode = str_replace("<%%ADDNEW({$ptfc[0]})%%>", '<button type="button" class="btn btn-success add_new_parent hspacer-md" id="' . $ptfc[0] . '_add_new" title="' . html_attr($Translation['Add New'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-plus-sign"></i></button>', $templateCode);
		}
	}

	// process images
	$templateCode = str_replace('<%%UPLOADFILE(id)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(id_categoria)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(data)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(nome)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(cpf)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(celular)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(email)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(cidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(uf)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(regiao)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(quantidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(unidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(uta)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(valor)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(obs)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(situacao)%%>', '', $templateCode);

	// process values
	if($selected_id) {
		if( $dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', safe_html($urow['id']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', html_attr($row['id']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode($urow['id']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(id_categoria)%%>', safe_html($urow['id_categoria']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(id_categoria)%%>', html_attr($row['id_categoria']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id_categoria)%%>', urlencode($urow['id_categoria']), $templateCode);
		$templateCode = str_replace('<%%VALUE(data)%%>', safe_html($urow['data']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(data)%%>', urlencode($urow['data']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(nome)%%>', safe_html($urow['nome']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(nome)%%>', html_attr($row['nome']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(nome)%%>', urlencode($urow['nome']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(cpf)%%>', safe_html($urow['cpf']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(cpf)%%>', html_attr($row['cpf']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cpf)%%>', urlencode($urow['cpf']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(celular)%%>', safe_html($urow['celular']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(celular)%%>', html_attr($row['celular']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(celular)%%>', urlencode($urow['celular']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(email)%%>', safe_html($urow['email']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(email)%%>', html_attr($row['email']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(email)%%>', urlencode($urow['email']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(cidade)%%>', safe_html($urow['cidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(cidade)%%>', html_attr($row['cidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cidade)%%>', urlencode($urow['cidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(uf)%%>', safe_html($urow['uf']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(uf)%%>', html_attr($row['uf']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uf)%%>', urlencode($urow['uf']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(regiao)%%>', safe_html($urow['regiao']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(regiao)%%>', html_attr($row['regiao']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(regiao)%%>', urlencode($urow['regiao']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(quantidade)%%>', safe_html($urow['quantidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(quantidade)%%>', html_attr($row['quantidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(quantidade)%%>', urlencode($urow['quantidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(unidade)%%>', safe_html($urow['unidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(unidade)%%>', html_attr($row['unidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unidade)%%>', urlencode($urow['unidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(uta)%%>', safe_html($urow['uta']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(uta)%%>', html_attr($row['uta']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uta)%%>', urlencode($urow['uta']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(valor)%%>', safe_html($urow['valor']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(valor)%%>', html_attr($row['valor']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(valor)%%>', urlencode($urow['valor']), $templateCode);
		if($dvprint || (!$AllowUpdate && !$AllowInsert)) {
			$templateCode = str_replace('<%%VALUE(obs)%%>', safe_html($urow['obs']), $templateCode);
		} else {
			$templateCode = str_replace('<%%VALUE(obs)%%>', safe_html($urow['obs'], true), $templateCode);
		}
		$templateCode = str_replace('<%%URLVALUE(obs)%%>', urlencode($urow['obs']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(situacao)%%>', safe_html($urow['situacao']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(situacao)%%>', html_attr($row['situacao']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(situacao)%%>', urlencode($urow['situacao']), $templateCode);
	} else {
		$templateCode = str_replace('<%%VALUE(id)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(id_categoria)%%>', ( $_REQUEST['FilterField'][1]=='2' && $_REQUEST['FilterOperator'][1]=='<=>' ? $combo_id_categoria->SelectedData : ''), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id_categoria)%%>', urlencode( $_REQUEST['FilterField'][1]=='2' && $_REQUEST['FilterOperator'][1]=='<=>' ? $combo_id_categoria->SelectedData : ''), $templateCode);
		$templateCode = str_replace('<%%VALUE(data)%%>', '<%%creationDateTime%%>', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(data)%%>', urlencode('<%%creationDateTime%%>'), $templateCode);
		$templateCode = str_replace('<%%VALUE(nome)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(nome)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(cpf)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cpf)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(celular)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(celular)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(email)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(email)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(cidade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cidade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(uf)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uf)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(regiao)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(regiao)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(quantidade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(quantidade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(unidade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unidade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(uta)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uta)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(valor)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(valor)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(obs)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(obs)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(situacao)%%>', 'INATIVA', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(situacao)%%>', urlencode('INATIVA'), $templateCode);
	}

	// process translations
	$templateCode = parseTemplate($templateCode);

	// clear scrap
	$templateCode = str_replace('<%%', '<!-- ', $templateCode);
	$templateCode = str_replace('%%>', ' -->', $templateCode);

	// hide links to inaccessible tables
	if($_REQUEST['dvprint_x'] == '') {
		$templateCode .= "\n\n<script>\$j(function() {\n";
		$arrTables = getTableList();
		foreach($arrTables as $name => $caption) {
			$templateCode .= "\t\$j('#{$name}_link').removeClass('hidden');\n";
			$templateCode .= "\t\$j('#xs_{$name}_link').removeClass('hidden');\n";
		}

		$templateCode .= $jsReadOnly;
		$templateCode .= $jsEditable;

		if(!$selected_id) {
		}

		$templateCode.="\n});</script>\n";
	}

	// ajaxed auto-fill fields
	$templateCode .= '<script>';
	$templateCode .= '$j(function() {';


	$templateCode.="});";
	$templateCode.="</script>";
	$templateCode .= $lookups;

	// handle enforced parent values for read-only lookup fields

	// don't include blank images in lightbox gallery
	$templateCode = preg_replace('/blank.gif" data-lightbox=".*?"/', 'blank.gif"', $templateCode);

	// don't display empty email links
	$templateCode=preg_replace('/<a .*?href="mailto:".*?<\/a>/', '', $templateCode);

	/* default field values */
	$rdata = $jdata = get_defaults('c001_ref');
	if($selected_id) {
		$jdata = get_joined_record('c001_ref', $selected_id);
		if($jdata === false) $jdata = get_defaults('c001_ref');
		$rdata = $row;
	}
	$templateCode .= loadView('c001_ref-ajax-cache', array('rdata' => $rdata, 'jdata' => $jdata));

	// hook: c001_ref_dv
	if(function_exists('c001_ref_dv')) {
		$args=[];
		c001_ref_dv(($selected_id ? $selected_id : FALSE), getMemberInfo(), $templateCode, $args);
	}

	return $templateCode;
}