<?php
	define('PREPEND_PATH', '');
	$app_dir = dirname(__FILE__);
	include_once("{$app_dir}/lib.php");

	// accept a record as an assoc array, return transformed row ready to insert to table
	$transformFunctions = [
		'sugerir_valor' => function($data, $options = []) {
			if(isset($data['categoria'])) $data['categoria'] = pkGivenLookupText($data['categoria'], 'sugerir_valor', 'categoria');
			if(isset($data['atividade'])) $data['atividade'] = pkGivenLookupText($data['atividade'], 'sugerir_valor', 'atividade');
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'sugerir_valor', 'unidade');

			return $data;
		},
		'sugerir_atividade' => function($data, $options = []) {
			if(isset($data['categoria'])) $data['categoria'] = pkGivenLookupText($data['categoria'], 'sugerir_atividade', 'categoria');
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'sugerir_atividade', 'unidade');
			if(isset($data['valor'])) $data['valor'] = str_replace('-', '', $data['valor']);

			return $data;
		},
		'c001' => function($data, $options = []) {
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c001', 'unidade');

			return $data;
		},
		'c001_ref' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c001_ref', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
		'c001_ref_colaborar' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c001_ref_colaborar', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c001_ref_colaborar', 'unidade');

			return $data;
		},
		'c001_ref_inativas' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c001_ref_inativas', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
		'categorias' => function($data, $options = []) {

			return $data;
		},
		'referencias_ativas' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'referencias_ativas', 'id_categoria');

			return $data;
		},
		'referencias_inativas' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'referencias_inativas', 'id_categoria');

			return $data;
		},
		'uta' => function($data, $options = []) {

			return $data;
		},
		'unidades' => function($data, $options = []) {

			return $data;
		},
		'atividades' => function($data, $options = []) {

			return $data;
		},
		'c002' => function($data, $options = []) {
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c002', 'unidade');

			return $data;
		},
		'c002_ref' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c002_ref', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
		'c002_ref_colaborar' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c002_ref_colaborar', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c002_ref_colaborar', 'unidade');

			return $data;
		},
		'c002_ref_inativas' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c002_ref_inativas', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
		'colaborar_atividade' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'colaborar_atividade', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);
			if(isset($data['colaboracao'])) $data['colaboracao'] = pkGivenLookupText($data['colaboracao'], 'colaborar_atividade', 'colaboracao');
			if(isset($data['categoria'])) $data['categoria'] = pkGivenLookupText($data['categoria'], 'colaborar_atividade', 'categoria');
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'colaborar_atividade', 'unidade');

			return $data;
		},
		'informacoes' => function($data, $options = []) {

			return $data;
		},
		'c003' => function($data, $options = []) {
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c003', 'unidade');

			return $data;
		},
		'c003_ref' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c003_ref', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
		'c003_ref_colaborar' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c003_ref_colaborar', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c003_ref_colaborar', 'unidade');

			return $data;
		},
		'c003_ref_inativas' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c003_ref_inativas', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
		'c004' => function($data, $options = []) {
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c004', 'unidade');

			return $data;
		},
		'c004_ref' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c004_ref', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
		'c004_ref_colaborar' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c004_ref_colaborar', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);
			if(isset($data['unidade'])) $data['unidade'] = pkGivenLookupText($data['unidade'], 'c004_ref_colaborar', 'unidade');

			return $data;
		},
		'c004_ref_inativas' => function($data, $options = []) {
			if(isset($data['id_categoria'])) $data['id_categoria'] = pkGivenLookupText($data['id_categoria'], 'c004_ref_inativas', 'id_categoria');
			if(isset($data['data'])) $data['data'] = guessMySQLDateTime($data['data']);

			return $data;
		},
	];

	// accept a record as an assoc array, return a boolean indicating whether to import or skip record
	$filterFunctions = [
		'sugerir_valor' => function($data, $options = []) { return true; },
		'sugerir_atividade' => function($data, $options = []) { return true; },
		'c001' => function($data, $options = []) { return true; },
		'c001_ref' => function($data, $options = []) { return true; },
		'c001_ref_colaborar' => function($data, $options = []) { return true; },
		'c001_ref_inativas' => function($data, $options = []) { return true; },
		'categorias' => function($data, $options = []) { return true; },
		'referencias_ativas' => function($data, $options = []) { return true; },
		'referencias_inativas' => function($data, $options = []) { return true; },
		'uta' => function($data, $options = []) { return true; },
		'unidades' => function($data, $options = []) { return true; },
		'atividades' => function($data, $options = []) { return true; },
		'c002' => function($data, $options = []) { return true; },
		'c002_ref' => function($data, $options = []) { return true; },
		'c002_ref_colaborar' => function($data, $options = []) { return true; },
		'c002_ref_inativas' => function($data, $options = []) { return true; },
		'colaborar_atividade' => function($data, $options = []) { return true; },
		'informacoes' => function($data, $options = []) { return true; },
		'c003' => function($data, $options = []) { return true; },
		'c003_ref' => function($data, $options = []) { return true; },
		'c003_ref_colaborar' => function($data, $options = []) { return true; },
		'c003_ref_inativas' => function($data, $options = []) { return true; },
		'c004' => function($data, $options = []) { return true; },
		'c004_ref' => function($data, $options = []) { return true; },
		'c004_ref_colaborar' => function($data, $options = []) { return true; },
		'c004_ref_inativas' => function($data, $options = []) { return true; },
	];

	/*
	Hook file for overwriting/amending $transformFunctions and $filterFunctions:
	hooks/import-csv.php
	If found, it's included below

	The way this works is by either completely overwriting any of the above 2 arrays,
	or, more commonly, overwriting a single function, for example:
		$transformFunctions['tablename'] = function($data, $options = []) {
			// new definition here
			// then you must return transformed data
			return $data;
		};

	Another scenario is transforming a specific field and leaving other fields to the default
	transformation. One possible way of doing this is to store the original transformation function
	in GLOBALS array, calling it inside the custom transformation function, then modifying the
	specific field:
		$GLOBALS['originalTransformationFunction'] = $transformFunctions['tablename'];
		$transformFunctions['tablename'] = function($data, $options = []) {
			$data = call_user_func_array($GLOBALS['originalTransformationFunction'], [$data, $options]);
			$data['fieldname'] = 'transformed value';
			return $data;
		};
	*/

	@include("{$app_dir}/hooks/import-csv.php");

	$ui = new CSVImportUI($transformFunctions, $filterFunctions);
