<?php

// Data functions (insert, update, delete, form) for table sugerir_valor

// This script and data application were generated by AppGini 5.97
// Download AppGini for free from https://bigprof.com/appgini/download/

function sugerir_valor_insert(&$error_message = '') {
	global $Translation;

	// mm: can member insert record?
	$arrPerm = getTablePermissions('sugerir_valor');
	if(!$arrPerm['insert']) return false;

	$data = [
		'data' => parseCode('<%%creationDateTime%%>', true),
		'nome' => Request::val('nome', ''),
		'cpf' => Request::val('cpf', ''),
		'celular' => Request::val('celular', ''),
		'email' => Request::val('email', ''),
		'cidade' => Request::val('cidade', ''),
		'uf' => Request::val('uf', ''),
		'categoria' => Request::lookup('categoria', ''),
		'atividade' => Request::lookup('atividade', ''),
		'quantidade' => Request::val('quantidade', ''),
		'unidade' => Request::lookup('unidade', ''),
		'valor' => Request::val('valor', ''),
		'obs' => br2nl(Request::val('obs', '')),
	];

	if($data['nome'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Nome': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['cpf'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'CPF': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['celular'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Celular': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['email'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'E-mail': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}

	// hook: sugerir_valor_before_insert
	if(function_exists('sugerir_valor_before_insert')) {
		$args = [];
		if(!sugerir_valor_before_insert($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$error = '';
	// set empty fields to NULL
	$data = array_map(function($v) { return ($v === '' ? NULL : $v); }, $data);
	insert('sugerir_valor', backtick_keys_once($data), $error);
	if($error)
		die("{$error}<br><a href=\"#\" onclick=\"history.go(-1);\">{$Translation['< back']}</a>");

	$recID = db_insert_id(db_link());

	// automatic categoria if passed as filterer
	if($_REQUEST['filterer_categoria']) {
		sql("UPDATE `sugerir_valor` SET `categoria`='" . makeSafe($_REQUEST['filterer_categoria']) . "' WHERE `id`='" . makeSafe($recID, false) . "'", $eo);
	}

	update_calc_fields('sugerir_valor', $recID, calculated_fields()['sugerir_valor']);

	// hook: sugerir_valor_after_insert
	if(function_exists('sugerir_valor_after_insert')) {
		$res = sql("SELECT * FROM `sugerir_valor` WHERE `id`='" . makeSafe($recID, false) . "' LIMIT 1", $eo);
		if($row = db_fetch_assoc($res)) {
			$data = array_map('makeSafe', $row);
		}
		$data['selectedID'] = makeSafe($recID, false);
		$args=[];
		if(!sugerir_valor_after_insert($data, getMemberInfo(), $args)) { return $recID; }
	}

	// mm: save ownership data
	set_record_owner('sugerir_valor', $recID, getLoggedMemberID());

	// if this record is a copy of another record, copy children if applicable
	if(!empty($_REQUEST['SelectedID'])) sugerir_valor_copy_children($recID, $_REQUEST['SelectedID']);

	return $recID;
}

function sugerir_valor_copy_children($destination_id, $source_id) {
	global $Translation;
	$requests = []; // array of curl handlers for launching insert requests
	$eo = ['silentErrors' => true];
	$safe_sid = makeSafe($source_id);

	// launch requests, asynchronously
	curl_batch($requests);
}

function sugerir_valor_delete($selected_id, $AllowDeleteOfParents = false, $skipChecks = false) {
	// insure referential integrity ...
	global $Translation;
	$selected_id = makeSafe($selected_id);

	// mm: can member delete record?
	if(!check_record_permission('sugerir_valor', $selected_id, 'delete')) {
		return $Translation['You don\'t have enough permissions to delete this record'];
	}

	// hook: sugerir_valor_before_delete
	if(function_exists('sugerir_valor_before_delete')) {
		$args = [];
		if(!sugerir_valor_before_delete($selected_id, $skipChecks, getMemberInfo(), $args))
			return $Translation['Couldn\'t delete this record'] . (
				!empty($args['error_message']) ?
					'<div class="text-bold">' . strip_tags($args['error_message']) . '</div>'
					: '' 
			);
	}

	sql("DELETE FROM `sugerir_valor` WHERE `id`='{$selected_id}'", $eo);

	// hook: sugerir_valor_after_delete
	if(function_exists('sugerir_valor_after_delete')) {
		$args = [];
		sugerir_valor_after_delete($selected_id, getMemberInfo(), $args);
	}

	// mm: delete ownership data
	sql("DELETE FROM `membership_userrecords` WHERE `tableName`='sugerir_valor' AND `pkValue`='{$selected_id}'", $eo);
}

function sugerir_valor_update(&$selected_id, &$error_message = '') {
	global $Translation;

	// mm: can member edit record?
	if(!check_record_permission('sugerir_valor', $selected_id, 'edit')) return false;

	$data = [
		'nome' => Request::val('nome', ''),
		'cpf' => Request::val('cpf', ''),
		'celular' => Request::val('celular', ''),
		'email' => Request::val('email', ''),
		'cidade' => Request::val('cidade', ''),
		'uf' => Request::val('uf', ''),
		'categoria' => Request::lookup('categoria', ''),
		'atividade' => Request::lookup('atividade', ''),
		'quantidade' => Request::val('quantidade', ''),
		'unidade' => Request::lookup('unidade', ''),
		'valor' => Request::val('valor', ''),
		'obs' => br2nl(Request::val('obs', '')),
	];

	if($data['nome'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Nome': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['cpf'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'CPF': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['celular'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Celular': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['email'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'E-mail': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	// get existing values
	$old_data = getRecord('sugerir_valor', $selected_id);
	if(is_array($old_data)) {
		$old_data = array_map('makeSafe', $old_data);
		$old_data['selectedID'] = makeSafe($selected_id);
	}

	$data['selectedID'] = makeSafe($selected_id);

	// hook: sugerir_valor_before_update
	if(function_exists('sugerir_valor_before_update')) {
		$args = ['old_data' => $old_data];
		if(!sugerir_valor_before_update($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$set = $data; unset($set['selectedID']);
	foreach ($set as $field => $value) {
		$set[$field] = ($value !== '' && $value !== NULL) ? $value : NULL;
	}

	if(!update(
		'sugerir_valor', 
		backtick_keys_once($set), 
		['`id`' => $selected_id], 
		$error_message
	)) {
		echo $error_message;
		echo '<a href="sugerir_valor_view.php?SelectedID=' . urlencode($selected_id) . "\">{$Translation['< back']}</a>";
		exit;
	}


	$eo = ['silentErrors' => true];

	update_calc_fields('sugerir_valor', $data['selectedID'], calculated_fields()['sugerir_valor']);

	// hook: sugerir_valor_after_update
	if(function_exists('sugerir_valor_after_update')) {
		$res = sql("SELECT * FROM `sugerir_valor` WHERE `id`='{$data['selectedID']}' LIMIT 1", $eo);
		if($row = db_fetch_assoc($res)) $data = array_map('makeSafe', $row);

		$data['selectedID'] = $data['id'];
		$args = ['old_data' => $old_data];
		if(!sugerir_valor_after_update($data, getMemberInfo(), $args)) return;
	}

	// mm: update ownership data
	sql("UPDATE `membership_userrecords` SET `dateUpdated`='" . time() . "' WHERE `tableName`='sugerir_valor' AND `pkValue`='" . makeSafe($selected_id) . "'", $eo);
}

function sugerir_valor_form($selected_id = '', $AllowUpdate = 1, $AllowInsert = 1, $AllowDelete = 1, $ShowCancel = 0, $TemplateDV = '', $TemplateDVP = '') {
	// function to return an editable form for a table records
	// and fill it with data of record whose ID is $selected_id. If $selected_id
	// is empty, an empty form is shown, with only an 'Add New'
	// button displayed.

	global $Translation;

	// mm: get table permissions
	$arrPerm = getTablePermissions('sugerir_valor');
	if(!$arrPerm['insert'] && $selected_id=='') return $Translation['tableAccessDenied'];
	$AllowInsert = ($arrPerm['insert'] ? true : false);
	// print preview?
	$dvprint = false;
	if($selected_id && $_REQUEST['dvprint_x'] != '') {
		$dvprint = true;
	}

	$filterer_categoria = thisOr($_REQUEST['filterer_categoria'], '');
	$filterer_atividade = thisOr($_REQUEST['filterer_atividade'], '');
	$filterer_unidade = thisOr($_REQUEST['filterer_unidade'], '');

	// populate filterers, starting from children to grand-parents

	// unique random identifier
	$rnd1 = ($dvprint ? rand(1000000, 9999999) : '');
	// combobox: uf
	$combo_uf = new Combo;
	$combo_uf->ListType = 0;
	$combo_uf->MultipleSeparator = ', ';
	$combo_uf->ListBoxHeight = 10;
	$combo_uf->RadiosPerLine = 1;
	if(is_file(dirname(__FILE__).'/hooks/sugerir_valor.uf.csv')) {
		$uf_data = addslashes(implode('', @file(dirname(__FILE__).'/hooks/sugerir_valor.uf.csv')));
		$combo_uf->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions($uf_data)));
		$combo_uf->ListData = $combo_uf->ListItem;
	} else {
		$combo_uf->ListItem = explode('||', entitiesToUTF8(convertLegacyOptions(";;AC;;AL;;AP;;AM;;BA;;CE;;DF;;ES;;GO;;MA;;MT;;MS;;MG;;PR;;PB;;PA;;PE;;PI;;RJ;;RN;;RS;;RO;;RR;;SC;;SE;;SP;;TO ")));
		$combo_uf->ListData = $combo_uf->ListItem;
	}
	$combo_uf->SelectName = 'uf';
	// combobox: categoria
	$combo_categoria = new DataCombo;
	// combobox: atividade
	$combo_atividade = new DataCombo;
	// combobox: unidade
	$combo_unidade = new DataCombo;

	if($selected_id) {
		// mm: check member permissions
		if(!$arrPerm['view']) return $Translation['tableAccessDenied'];

		// mm: who is the owner?
		$ownerGroupID = sqlValue("SELECT `groupID` FROM `membership_userrecords` WHERE `tableName`='sugerir_valor' AND `pkValue`='" . makeSafe($selected_id) . "'");
		$ownerMemberID = sqlValue("SELECT LCASE(`memberID`) FROM `membership_userrecords` WHERE `tableName`='sugerir_valor' AND `pkValue`='" . makeSafe($selected_id) . "'");

		if($arrPerm['view'] == 1 && getLoggedMemberID() != $ownerMemberID) return $Translation['tableAccessDenied'];
		if($arrPerm['view'] == 2 && getLoggedGroupID() != $ownerGroupID) return $Translation['tableAccessDenied'];

		// can edit?
		$AllowUpdate = 0;
		if(($arrPerm['edit'] == 1 && $ownerMemberID == getLoggedMemberID()) || ($arrPerm['edit'] == 2 && $ownerGroupID == getLoggedGroupID()) || $arrPerm['edit'] == 3) {
			$AllowUpdate = 1;
		}

		$res = sql("SELECT * FROM `sugerir_valor` WHERE `id`='" . makeSafe($selected_id) . "'", $eo);
		if(!($row = db_fetch_array($res))) {
			return error_message($Translation['No records found'], 'sugerir_valor_view.php', false);
		}
		$combo_uf->SelectedData = $row['uf'];
		$combo_categoria->SelectedData = $row['categoria'];
		$combo_atividade->SelectedData = $row['atividade'];
		$combo_unidade->SelectedData = $row['unidade'];
		$urow = $row; /* unsanitized data */
		$row = array_map('safe_html', $row);
	} else {
		$combo_uf->SelectedText = ( $_REQUEST['FilterField'][1] == '8' && $_REQUEST['FilterOperator'][1] == '<=>' ? $_REQUEST['FilterValue'][1] : '');
		$combo_categoria->SelectedData = $filterer_categoria;
		$combo_atividade->SelectedData = $filterer_atividade;
		$combo_unidade->SelectedData = $filterer_unidade;
	}
	$combo_uf->Render();
	$combo_categoria->HTML = '<span id="categoria-container' . $rnd1 . '"></span><input type="hidden" name="categoria" id="categoria' . $rnd1 . '" value="' . html_attr($combo_categoria->SelectedData) . '">';
	$combo_categoria->MatchText = '<span id="categoria-container-readonly' . $rnd1 . '"></span><input type="hidden" name="categoria" id="categoria' . $rnd1 . '" value="' . html_attr($combo_categoria->SelectedData) . '">';
	$combo_atividade->HTML = '<span id="atividade-container' . $rnd1 . '"></span><input type="hidden" name="atividade" id="atividade' . $rnd1 . '" value="' . html_attr($combo_atividade->SelectedData) . '">';
	$combo_atividade->MatchText = '<span id="atividade-container-readonly' . $rnd1 . '"></span><input type="hidden" name="atividade" id="atividade' . $rnd1 . '" value="' . html_attr($combo_atividade->SelectedData) . '">';
	$combo_unidade->HTML = '<span id="unidade-container' . $rnd1 . '"></span><input type="hidden" name="unidade" id="unidade' . $rnd1 . '" value="' . html_attr($combo_unidade->SelectedData) . '">';
	$combo_unidade->MatchText = '<span id="unidade-container-readonly' . $rnd1 . '"></span><input type="hidden" name="unidade" id="unidade' . $rnd1 . '" value="' . html_attr($combo_unidade->SelectedData) . '">';

	ob_start();
	?>

	<script>
		// initial lookup values
		AppGini.current_categoria__RAND__ = { text: "", value: "<?php echo addslashes($selected_id ? $urow['categoria'] : htmlspecialchars($filterer_categoria, ENT_QUOTES)); ?>"};
		AppGini.current_atividade__RAND__ = { text: "", value: "<?php echo addslashes($selected_id ? $urow['atividade'] : htmlspecialchars($filterer_atividade, ENT_QUOTES)); ?>"};
		AppGini.current_unidade__RAND__ = { text: "", value: "<?php echo addslashes($selected_id ? $urow['unidade'] : htmlspecialchars($filterer_unidade, ENT_QUOTES)); ?>"};

		jQuery(function() {
			setTimeout(function() {
				if(typeof(categoria_reload__RAND__) == 'function') categoria_reload__RAND__();
				if(typeof(atividade_reload__RAND__) == 'function') atividade_reload__RAND__();
				if(typeof(unidade_reload__RAND__) == 'function') unidade_reload__RAND__();
			}, 50); /* we need to slightly delay client-side execution of the above code to allow AppGini.ajaxCache to work */
		});
		function categoria_reload__RAND__() {
		<?php if(($AllowUpdate || $AllowInsert) && !$dvprint) { ?>

			$j("#categoria-container__RAND__").select2({
				/* initial default value */
				initSelection: function(e, c) {
					$j.ajax({
						url: 'ajax_combo.php',
						dataType: 'json',
						data: { id: AppGini.current_categoria__RAND__.value, t: 'sugerir_valor', f: 'categoria' },
						success: function(resp) {
							c({
								id: resp.results[0].id,
								text: resp.results[0].text
							});
							$j('[name="categoria"]').val(resp.results[0].id);
							$j('[id=categoria-container-readonly__RAND__]').html('<span id="categoria-match-text">' + resp.results[0].text + '</span>');
							if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=categorias_view_parent]').hide(); } else { $j('.btn[id=categorias_view_parent]').show(); }


							if(typeof(categoria_update_autofills__RAND__) == 'function') categoria_update_autofills__RAND__();
						}
					});
				},
				width: '100%',
				formatNoMatches: function(term) { return '<?php echo addslashes($Translation['No matches found!']); ?>'; },
				minimumResultsForSearch: 5,
				loadMorePadding: 200,
				ajax: {
					url: 'ajax_combo.php',
					dataType: 'json',
					cache: true,
					data: function(term, page) { return { s: term, p: page, t: 'sugerir_valor', f: 'categoria' }; },
					results: function(resp, page) { return resp; }
				},
				escapeMarkup: function(str) { return str; }
			}).on('change', function(e) {
				AppGini.current_categoria__RAND__.value = e.added.id;
				AppGini.current_categoria__RAND__.text = e.added.text;
				$j('[name="categoria"]').val(e.added.id);
				if(e.added.id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=categorias_view_parent]').hide(); } else { $j('.btn[id=categorias_view_parent]').show(); }


				if(typeof(categoria_update_autofills__RAND__) == 'function') categoria_update_autofills__RAND__();
			});

			if(!$j("#categoria-container__RAND__").length) {
				$j.ajax({
					url: 'ajax_combo.php',
					dataType: 'json',
					data: { id: AppGini.current_categoria__RAND__.value, t: 'sugerir_valor', f: 'categoria' },
					success: function(resp) {
						$j('[name="categoria"]').val(resp.results[0].id);
						$j('[id=categoria-container-readonly__RAND__]').html('<span id="categoria-match-text">' + resp.results[0].text + '</span>');
						if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=categorias_view_parent]').hide(); } else { $j('.btn[id=categorias_view_parent]').show(); }

						if(typeof(categoria_update_autofills__RAND__) == 'function') categoria_update_autofills__RAND__();
					}
				});
			}

		<?php } else { ?>

			$j.ajax({
				url: 'ajax_combo.php',
				dataType: 'json',
				data: { id: AppGini.current_categoria__RAND__.value, t: 'sugerir_valor', f: 'categoria' },
				success: function(resp) {
					$j('[id=categoria-container__RAND__], [id=categoria-container-readonly__RAND__]').html('<span id="categoria-match-text">' + resp.results[0].text + '</span>');
					if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=categorias_view_parent]').hide(); } else { $j('.btn[id=categorias_view_parent]').show(); }

					if(typeof(categoria_update_autofills__RAND__) == 'function') categoria_update_autofills__RAND__();
				}
			});
		<?php } ?>

		}
		function atividade_reload__RAND__() {
		<?php if(($AllowUpdate || $AllowInsert) && !$dvprint) { ?>

			$j("#atividade-container__RAND__").select2({
				/* initial default value */
				initSelection: function(e, c) {
					$j.ajax({
						url: 'ajax_combo.php',
						dataType: 'json',
						data: { id: AppGini.current_atividade__RAND__.value, t: 'sugerir_valor', f: 'atividade' },
						success: function(resp) {
							c({
								id: resp.results[0].id,
								text: resp.results[0].text
							});
							$j('[name="atividade"]').val(resp.results[0].id);
							$j('[id=atividade-container-readonly__RAND__]').html('<span id="atividade-match-text">' + resp.results[0].text + '</span>');
							if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=atividades_view_parent]').hide(); } else { $j('.btn[id=atividades_view_parent]').show(); }


							if(typeof(atividade_update_autofills__RAND__) == 'function') atividade_update_autofills__RAND__();
						}
					});
				},
				width: '100%',
				formatNoMatches: function(term) { return '<?php echo addslashes($Translation['No matches found!']); ?>'; },
				minimumResultsForSearch: 5,
				loadMorePadding: 200,
				ajax: {
					url: 'ajax_combo.php',
					dataType: 'json',
					cache: true,
					data: function(term, page) { return { s: term, p: page, t: 'sugerir_valor', f: 'atividade' }; },
					results: function(resp, page) { return resp; }
				},
				escapeMarkup: function(str) { return str; }
			}).on('change', function(e) {
				AppGini.current_atividade__RAND__.value = e.added.id;
				AppGini.current_atividade__RAND__.text = e.added.text;
				$j('[name="atividade"]').val(e.added.id);
				if(e.added.id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=atividades_view_parent]').hide(); } else { $j('.btn[id=atividades_view_parent]').show(); }


				if(typeof(atividade_update_autofills__RAND__) == 'function') atividade_update_autofills__RAND__();
			});

			if(!$j("#atividade-container__RAND__").length) {
				$j.ajax({
					url: 'ajax_combo.php',
					dataType: 'json',
					data: { id: AppGini.current_atividade__RAND__.value, t: 'sugerir_valor', f: 'atividade' },
					success: function(resp) {
						$j('[name="atividade"]').val(resp.results[0].id);
						$j('[id=atividade-container-readonly__RAND__]').html('<span id="atividade-match-text">' + resp.results[0].text + '</span>');
						if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=atividades_view_parent]').hide(); } else { $j('.btn[id=atividades_view_parent]').show(); }

						if(typeof(atividade_update_autofills__RAND__) == 'function') atividade_update_autofills__RAND__();
					}
				});
			}

		<?php } else { ?>

			$j.ajax({
				url: 'ajax_combo.php',
				dataType: 'json',
				data: { id: AppGini.current_atividade__RAND__.value, t: 'sugerir_valor', f: 'atividade' },
				success: function(resp) {
					$j('[id=atividade-container__RAND__], [id=atividade-container-readonly__RAND__]').html('<span id="atividade-match-text">' + resp.results[0].text + '</span>');
					if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=atividades_view_parent]').hide(); } else { $j('.btn[id=atividades_view_parent]').show(); }

					if(typeof(atividade_update_autofills__RAND__) == 'function') atividade_update_autofills__RAND__();
				}
			});
		<?php } ?>

		}
		function unidade_reload__RAND__() {
		<?php if(($AllowUpdate || $AllowInsert) && !$dvprint) { ?>

			$j("#unidade-container__RAND__").select2({
				/* initial default value */
				initSelection: function(e, c) {
					$j.ajax({
						url: 'ajax_combo.php',
						dataType: 'json',
						data: { id: AppGini.current_unidade__RAND__.value, t: 'sugerir_valor', f: 'unidade' },
						success: function(resp) {
							c({
								id: resp.results[0].id,
								text: resp.results[0].text
							});
							$j('[name="unidade"]').val(resp.results[0].id);
							$j('[id=unidade-container-readonly__RAND__]').html('<span id="unidade-match-text">' + resp.results[0].text + '</span>');
							if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }


							if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
						}
					});
				},
				width: '100%',
				formatNoMatches: function(term) { return '<?php echo addslashes($Translation['No matches found!']); ?>'; },
				minimumResultsForSearch: 5,
				loadMorePadding: 200,
				ajax: {
					url: 'ajax_combo.php',
					dataType: 'json',
					cache: true,
					data: function(term, page) { return { s: term, p: page, t: 'sugerir_valor', f: 'unidade' }; },
					results: function(resp, page) { return resp; }
				},
				escapeMarkup: function(str) { return str; }
			}).on('change', function(e) {
				AppGini.current_unidade__RAND__.value = e.added.id;
				AppGini.current_unidade__RAND__.text = e.added.text;
				$j('[name="unidade"]').val(e.added.id);
				if(e.added.id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }


				if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
			});

			if(!$j("#unidade-container__RAND__").length) {
				$j.ajax({
					url: 'ajax_combo.php',
					dataType: 'json',
					data: { id: AppGini.current_unidade__RAND__.value, t: 'sugerir_valor', f: 'unidade' },
					success: function(resp) {
						$j('[name="unidade"]').val(resp.results[0].id);
						$j('[id=unidade-container-readonly__RAND__]').html('<span id="unidade-match-text">' + resp.results[0].text + '</span>');
						if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }

						if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
					}
				});
			}

		<?php } else { ?>

			$j.ajax({
				url: 'ajax_combo.php',
				dataType: 'json',
				data: { id: AppGini.current_unidade__RAND__.value, t: 'sugerir_valor', f: 'unidade' },
				success: function(resp) {
					$j('[id=unidade-container__RAND__], [id=unidade-container-readonly__RAND__]').html('<span id="unidade-match-text">' + resp.results[0].text + '</span>');
					if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=unidades_view_parent]').hide(); } else { $j('.btn[id=unidades_view_parent]').show(); }

					if(typeof(unidade_update_autofills__RAND__) == 'function') unidade_update_autofills__RAND__();
				}
			});
		<?php } ?>

		}
	</script>
	<?php

	$lookups = str_replace('__RAND__', $rnd1, ob_get_contents());
	ob_end_clean();


	// code for template based detail view forms

	// open the detail view template
	if($dvprint) {
		$template_file = is_file("./{$TemplateDVP}") ? "./{$TemplateDVP}" : './templates/sugerir_valor_templateDVP.html';
		$templateCode = @file_get_contents($template_file);
	} else {
		$template_file = is_file("./{$TemplateDV}") ? "./{$TemplateDV}" : './templates/sugerir_valor_templateDV.html';
		$templateCode = @file_get_contents($template_file);
	}

	// process form title
	$templateCode = str_replace('<%%DETAIL_VIEW_TITLE%%>', 'Detalhes', $templateCode);
	$templateCode = str_replace('<%%RND1%%>', $rnd1, $templateCode);
	$templateCode = str_replace('<%%EMBEDDED%%>', ($_REQUEST['Embedded'] ? 'Embedded=1' : ''), $templateCode);
	// process buttons
	if($AllowInsert) {
		if(!$selected_id) $templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-success" id="insert" name="insert_x" value="1" onclick="return sugerir_valor_validateData();"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save New'] . '</button>', $templateCode);
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="insert" name="insert_x" value="1" onclick="return sugerir_valor_validateData();"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save As Copy'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '', $templateCode);
	}

	// 'Back' button action
	if($_REQUEST['Embedded']) {
		$backAction = 'AppGini.closeParentModal(); return false;';
	} else {
		$backAction = '$j(\'form\').eq(0).attr(\'novalidate\', \'novalidate\'); document.myform.reset(); return true;';
	}

	if($selected_id) {
		if(!$_REQUEST['Embedded']) $templateCode = str_replace('<%%DVPRINT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="dvprint" name="dvprint_x" value="1" onclick="$j(\'form\').eq(0).prop(\'novalidate\', true); document.myform.reset(); return true;" title="' . html_attr($Translation['Print Preview']) . '"><i class="glyphicon glyphicon-print"></i> ' . $Translation['Print Preview'] . '</button>', $templateCode);
		if($AllowUpdate) {
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '<button type="submit" class="btn btn-success btn-lg" id="update" name="update_x" value="1" onclick="return sugerir_valor_validateData();" title="' . html_attr($Translation['Save Changes']) . '"><i class="glyphicon glyphicon-ok"></i> ' . $Translation['Save Changes'] . '</button>', $templateCode);
		} else {
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		}
		if(($arrPerm[4]==1 && $ownerMemberID==getLoggedMemberID()) || ($arrPerm[4]==2 && $ownerGroupID==getLoggedGroupID()) || $arrPerm[4]==3) { // allow delete?
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '<button type="submit" class="btn btn-danger" id="delete" name="delete_x" value="1" onclick="return confirm(\'' . $Translation['are you sure?'] . '\');" title="' . html_attr($Translation['Delete']) . '"><i class="glyphicon glyphicon-trash"></i> ' . $Translation['Delete'] . '</button>', $templateCode);
		} else {
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);
		}
		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', ($ShowCancel ? '<button type="submit" class="btn btn-default" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>' : ''), $templateCode);
	}

	// set records to read only if user can't insert new records and can't edit current record
	if(($selected_id && !$AllowUpdate && !$AllowInsert) || (!$selected_id && !$AllowInsert)) {
		$jsReadOnly = '';
		$jsReadOnly .= "\tjQuery('#nome').replaceWith('<div class=\"form-control-static\" id=\"nome\">' + (jQuery('#nome').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#cpf').replaceWith('<div class=\"form-control-static\" id=\"cpf\">' + (jQuery('#cpf').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#celular').replaceWith('<div class=\"form-control-static\" id=\"celular\">' + (jQuery('#celular').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#email').replaceWith('<div class=\"form-control-static\" id=\"email\">' + (jQuery('#email').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#cidade').replaceWith('<div class=\"form-control-static\" id=\"cidade\">' + (jQuery('#cidade').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#uf').replaceWith('<div class=\"form-control-static\" id=\"uf\">' + (jQuery('#uf').val() || '') + '</div>'); jQuery('#uf-multi-selection-help').hide();\n";
		$jsReadOnly .= "\tjQuery('#atividade').prop('disabled', true).css({ color: '#555', backgroundColor: '#fff' });\n";
		$jsReadOnly .= "\tjQuery('#atividade_caption').prop('disabled', true).css({ color: '#555', backgroundColor: 'white' });\n";
		$jsReadOnly .= "\tjQuery('#quantidade').replaceWith('<div class=\"form-control-static\" id=\"quantidade\">' + (jQuery('#quantidade').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#unidade').prop('disabled', true).css({ color: '#555', backgroundColor: '#fff' });\n";
		$jsReadOnly .= "\tjQuery('#unidade_caption').prop('disabled', true).css({ color: '#555', backgroundColor: 'white' });\n";
		$jsReadOnly .= "\tjQuery('#valor').replaceWith('<div class=\"form-control-static\" id=\"valor\">' + (jQuery('#valor').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#obs').replaceWith('<div class=\"form-control-static\" id=\"obs\">' + (jQuery('#obs').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('.select2-container').hide();\n";

		$noUploads = true;
	} elseif($AllowInsert) {
		$jsEditable = "\tjQuery('form').eq(0).data('already_changed', true);"; // temporarily disable form change handler
		$jsEditable .= "\tjQuery('form').eq(0).data('already_changed', false);"; // re-enable form change handler
	}

	// process combos
	$templateCode = str_replace('<%%COMBO(uf)%%>', $combo_uf->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(uf)%%>', $combo_uf->SelectedData, $templateCode);
	$templateCode = str_replace('<%%COMBO(categoria)%%>', $combo_categoria->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(categoria)%%>', $combo_categoria->MatchText, $templateCode);
	$templateCode = str_replace('<%%URLCOMBOTEXT(categoria)%%>', urlencode($combo_categoria->MatchText), $templateCode);
	$templateCode = str_replace('<%%COMBO(atividade)%%>', $combo_atividade->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(atividade)%%>', $combo_atividade->MatchText, $templateCode);
	$templateCode = str_replace('<%%URLCOMBOTEXT(atividade)%%>', urlencode($combo_atividade->MatchText), $templateCode);
	$templateCode = str_replace('<%%COMBO(unidade)%%>', $combo_unidade->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(unidade)%%>', $combo_unidade->MatchText, $templateCode);
	$templateCode = str_replace('<%%URLCOMBOTEXT(unidade)%%>', urlencode($combo_unidade->MatchText), $templateCode);

	/* lookup fields array: 'lookup field name' => array('parent table name', 'lookup field caption') */
	$lookup_fields = array('categoria' => array('categorias', 'Categoria'), 'atividade' => array('atividades', 'Atividade'), 'unidade' => array('unidades', 'Unidade'), );
	foreach($lookup_fields as $luf => $ptfc) {
		$pt_perm = getTablePermissions($ptfc[0]);

		// process foreign key links
		if($pt_perm['view'] || $pt_perm['edit']) {
			$templateCode = str_replace("<%%PLINK({$luf})%%>", '<button type="button" class="btn btn-default view_parent hspacer-md" id="' . $ptfc[0] . '_view_parent" title="' . html_attr($Translation['View'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-eye-open"></i></button>', $templateCode);
		}

		// if user has insert permission to parent table of a lookup field, put an add new button
		if($pt_perm['insert'] /* && !$_REQUEST['Embedded']*/) {
			$templateCode = str_replace("<%%ADDNEW({$ptfc[0]})%%>", '<button type="button" class="btn btn-success add_new_parent hspacer-md" id="' . $ptfc[0] . '_add_new" title="' . html_attr($Translation['Add New'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-plus-sign"></i></button>', $templateCode);
		}
	}

	// process images
	$templateCode = str_replace('<%%UPLOADFILE(id)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(data)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(nome)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(cpf)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(celular)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(email)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(cidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(uf)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(categoria)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(atividade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(quantidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(unidade)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(valor)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(obs)%%>', '', $templateCode);

	// process values
	if($selected_id) {
		if( $dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', safe_html($urow['id']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', html_attr($row['id']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode($urow['id']), $templateCode);
		$templateCode = str_replace('<%%VALUE(data)%%>', safe_html($urow['data']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(data)%%>', urlencode($urow['data']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(nome)%%>', safe_html($urow['nome']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(nome)%%>', html_attr($row['nome']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(nome)%%>', urlencode($urow['nome']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(cpf)%%>', safe_html($urow['cpf']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(cpf)%%>', html_attr($row['cpf']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cpf)%%>', urlencode($urow['cpf']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(celular)%%>', safe_html($urow['celular']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(celular)%%>', html_attr($row['celular']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(celular)%%>', urlencode($urow['celular']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(email)%%>', safe_html($urow['email']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(email)%%>', html_attr($row['email']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(email)%%>', urlencode($urow['email']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(cidade)%%>', safe_html($urow['cidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(cidade)%%>', html_attr($row['cidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cidade)%%>', urlencode($urow['cidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(uf)%%>', safe_html($urow['uf']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(uf)%%>', html_attr($row['uf']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uf)%%>', urlencode($urow['uf']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(categoria)%%>', safe_html($urow['categoria']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(categoria)%%>', html_attr($row['categoria']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(categoria)%%>', urlencode($urow['categoria']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(atividade)%%>', safe_html($urow['atividade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(atividade)%%>', html_attr($row['atividade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(atividade)%%>', urlencode($urow['atividade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(quantidade)%%>', safe_html($urow['quantidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(quantidade)%%>', html_attr($row['quantidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(quantidade)%%>', urlencode($urow['quantidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(unidade)%%>', safe_html($urow['unidade']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(unidade)%%>', html_attr($row['unidade']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unidade)%%>', urlencode($urow['unidade']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(valor)%%>', safe_html($urow['valor']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(valor)%%>', html_attr($row['valor']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(valor)%%>', urlencode($urow['valor']), $templateCode);
		if($dvprint || (!$AllowUpdate && !$AllowInsert)) {
			$templateCode = str_replace('<%%VALUE(obs)%%>', safe_html($urow['obs']), $templateCode);
		} else {
			$templateCode = str_replace('<%%VALUE(obs)%%>', safe_html($urow['obs'], true), $templateCode);
		}
		$templateCode = str_replace('<%%URLVALUE(obs)%%>', urlencode($urow['obs']), $templateCode);
	} else {
		$templateCode = str_replace('<%%VALUE(id)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(data)%%>', '<%%creationDateTime%%>', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(data)%%>', urlencode('<%%creationDateTime%%>'), $templateCode);
		$templateCode = str_replace('<%%VALUE(nome)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(nome)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(cpf)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cpf)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(celular)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(celular)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(email)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(email)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(cidade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(cidade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(uf)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(uf)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(categoria)%%>', ( $_REQUEST['FilterField'][1]=='9' && $_REQUEST['FilterOperator'][1]=='<=>' ? $combo_categoria->SelectedData : ''), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(categoria)%%>', urlencode( $_REQUEST['FilterField'][1]=='9' && $_REQUEST['FilterOperator'][1]=='<=>' ? $combo_categoria->SelectedData : ''), $templateCode);
		$templateCode = str_replace('<%%VALUE(atividade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(atividade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(quantidade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(quantidade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(unidade)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unidade)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(valor)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(valor)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(obs)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(obs)%%>', urlencode(''), $templateCode);
	}

	// process translations
	$templateCode = parseTemplate($templateCode);

	// clear scrap
	$templateCode = str_replace('<%%', '<!-- ', $templateCode);
	$templateCode = str_replace('%%>', ' -->', $templateCode);

	// hide links to inaccessible tables
	if($_REQUEST['dvprint_x'] == '') {
		$templateCode .= "\n\n<script>\$j(function() {\n";
		$arrTables = getTableList();
		foreach($arrTables as $name => $caption) {
			$templateCode .= "\t\$j('#{$name}_link').removeClass('hidden');\n";
			$templateCode .= "\t\$j('#xs_{$name}_link').removeClass('hidden');\n";
		}

		$templateCode .= $jsReadOnly;
		$templateCode .= $jsEditable;

		if(!$selected_id) {
		}

		$templateCode.="\n});</script>\n";
	}

	// ajaxed auto-fill fields
	$templateCode .= '<script>';
	$templateCode .= '$j(function() {';


	$templateCode.="});";
	$templateCode.="</script>";
	$templateCode .= $lookups;

	// handle enforced parent values for read-only lookup fields

	// don't include blank images in lightbox gallery
	$templateCode = preg_replace('/blank.gif" data-lightbox=".*?"/', 'blank.gif"', $templateCode);

	// don't display empty email links
	$templateCode=preg_replace('/<a .*?href="mailto:".*?<\/a>/', '', $templateCode);

	/* default field values */
	$rdata = $jdata = get_defaults('sugerir_valor');
	if($selected_id) {
		$jdata = get_joined_record('sugerir_valor', $selected_id);
		if($jdata === false) $jdata = get_defaults('sugerir_valor');
		$rdata = $row;
	}
	$templateCode .= loadView('sugerir_valor-ajax-cache', array('rdata' => $rdata, 'jdata' => $jdata));

	// hook: sugerir_valor_dv
	if(function_exists('sugerir_valor_dv')) {
		$args=[];
		sugerir_valor_dv(($selected_id ? $selected_id : FALSE), getMemberInfo(), $templateCode, $args);
	}

	return $templateCode;
}