<?php
	// check this file's MD5 to make sure it wasn't called before
	$prevMD5 = @file_get_contents(dirname(__FILE__) . '/setup.md5');
	$thisMD5 = md5(@file_get_contents(dirname(__FILE__) . '/updateDB.php'));

	// check if setup already run
	if($thisMD5 != $prevMD5) {
		// $silent is set if this file is included from setup.php
		if(!isset($silent)) $silent = true;

		// set up tables
		setupTable(
			'sugerir_valor', " 
			CREATE TABLE IF NOT EXISTS `sugerir_valor` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`data` VARCHAR(80) NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`categoria` INT UNSIGNED NULL,
				`atividade` INT UNSIGNED NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`valor` VARCHAR(80) NULL,
				`obs` LONGTEXT NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('sugerir_valor', ['categoria','atividade','unidade',]);

		setupTable(
			'sugerir_atividade', " 
			CREATE TABLE IF NOT EXISTS `sugerir_atividade` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`data` VARCHAR(80) NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`categoria` INT UNSIGNED NOT NULL,
				`atividade` VARCHAR(255) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`valor` VARCHAR(80) NULL,
				`obs` LONGTEXT NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('sugerir_atividade', ['categoria','unidade',]);

		setupTable(
			'c001', " 
			CREATE TABLE IF NOT EXISTS `c001` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`cod_categoria` VARCHAR(80) NULL,
				`categoria` VARCHAR(80) NULL,
				`atividade` LONGTEXT NOT NULL,
				`descricao` LONGTEXT NOT NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c001', ['unidade',]);

		setupTable(
			'c001_ref', " 
			CREATE TABLE IF NOT EXISTS `c001_ref` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NULL,
				`cpf` VARCHAR(80) NULL,
				`celular` VARCHAR(80) NULL,
				`email` VARCHAR(80) NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c001_ref', ['id_categoria',]);

		setupTable(
			'c001_ref_colaborar', " 
			CREATE TABLE IF NOT EXISTS `c001_ref_colaborar` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`espaco` VARCHAR(80) NULL,
				`colaboracao` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`valor` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c001_ref_colaborar', ['id_categoria','unidade',]);

		setupTable(
			'c001_ref_inativas', " 
			CREATE TABLE IF NOT EXISTS `c001_ref_inativas` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c001_ref_inativas', ['id_categoria',]);

		setupTable(
			'categorias', " 
			CREATE TABLE IF NOT EXISTS `categorias` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`cod` VARCHAR(20) NULL,
				`nome` LONGTEXT NULL,
				`atividade` LONGTEXT NULL,
				`descricao` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);

		setupTable(
			'referencias_ativas', " 
			CREATE TABLE IF NOT EXISTS `referencias_ativas` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`data` VARCHAR(80) NULL,
				`id_categoria` INT UNSIGNED NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('referencias_ativas', ['id_categoria',]);

		setupTable(
			'referencias_inativas', " 
			CREATE TABLE IF NOT EXISTS `referencias_inativas` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`data` VARCHAR(80) NULL,
				`id_categoria` INT UNSIGNED NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('referencias_inativas', ['id_categoria',]);

		setupTable(
			'uta', " 
			CREATE TABLE IF NOT EXISTS `uta` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`nome` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);

		setupTable(
			'unidades', " 
			CREATE TABLE IF NOT EXISTS `unidades` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`unidade` VARCHAR(80) NULL,
				`obs` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);

		setupTable(
			'atividades', " 
			CREATE TABLE IF NOT EXISTS `atividades` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`categoria` VARCHAR(80) NULL,
				`atividade` TEXT NULL,
				`descricao` TEXT NULL
			) CHARSET utf8",
			$silent
		);

		setupTable(
			'c002', " 
			CREATE TABLE IF NOT EXISTS `c002` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`atividade` LONGTEXT NOT NULL,
				`descricao` LONGTEXT NOT NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c002', ['unidade',]);

		setupTable(
			'c002_ref', " 
			CREATE TABLE IF NOT EXISTS `c002_ref` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NULL,
				`cpf` VARCHAR(80) NULL,
				`celular` VARCHAR(80) NULL,
				`email` VARCHAR(80) NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c002_ref', ['id_categoria',]);

		setupTable(
			'c002_ref_colaborar', " 
			CREATE TABLE IF NOT EXISTS `c002_ref_colaborar` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`espaco` VARCHAR(80) NULL,
				`colaboracao` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`valor` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c002_ref_colaborar', ['id_categoria','unidade',]);

		setupTable(
			'c002_ref_inativas', " 
			CREATE TABLE IF NOT EXISTS `c002_ref_inativas` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c002_ref_inativas', ['id_categoria',]);

		setupTable(
			'colaborar_atividade', " 
			CREATE TABLE IF NOT EXISTS `colaborar_atividade` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`espaco` VARCHAR(80) NULL,
				`colaboracao` INT UNSIGNED NULL,
				`categoria` INT UNSIGNED NULL,
				`atividade` VARCHAR(255) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`valor` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('colaborar_atividade', ['id_categoria','colaboracao','categoria','unidade',]);

		setupTable(
			'informacoes', " 
			CREATE TABLE IF NOT EXISTS `informacoes` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`assunto` VARCHAR(255) NULL,
				`nome` TEXT NULL
			) CHARSET utf8",
			$silent
		);

		setupTable(
			'c003', " 
			CREATE TABLE IF NOT EXISTS `c003` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`atividade` LONGTEXT NOT NULL,
				`descricao` LONGTEXT NOT NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c003', ['unidade',]);

		setupTable(
			'c003_ref', " 
			CREATE TABLE IF NOT EXISTS `c003_ref` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NULL,
				`cpf` VARCHAR(80) NULL,
				`celular` VARCHAR(80) NULL,
				`email` VARCHAR(80) NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c003_ref', ['id_categoria',]);

		setupTable(
			'c003_ref_colaborar', " 
			CREATE TABLE IF NOT EXISTS `c003_ref_colaborar` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`espaco` VARCHAR(80) NULL,
				`colaboracao` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`valor` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c003_ref_colaborar', ['id_categoria','unidade',]);

		setupTable(
			'c003_ref_inativas', " 
			CREATE TABLE IF NOT EXISTS `c003_ref_inativas` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c003_ref_inativas', ['id_categoria',]);

		setupTable(
			'c004', " 
			CREATE TABLE IF NOT EXISTS `c004` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`atividade` LONGTEXT NOT NULL,
				`descricao` LONGTEXT NOT NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c004', ['unidade',]);

		setupTable(
			'c004_ref', " 
			CREATE TABLE IF NOT EXISTS `c004_ref` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NULL,
				`cpf` VARCHAR(80) NULL,
				`celular` VARCHAR(80) NULL,
				`email` VARCHAR(80) NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c004_ref', ['id_categoria',]);

		setupTable(
			'c004_ref_colaborar', " 
			CREATE TABLE IF NOT EXISTS `c004_ref_colaborar` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`espaco` VARCHAR(80) NULL,
				`colaboracao` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` INT UNSIGNED NULL,
				`valor` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL DEFAULT 'INATIVA'
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c004_ref_colaborar', ['id_categoria','unidade',]);

		setupTable(
			'c004_ref_inativas', " 
			CREATE TABLE IF NOT EXISTS `c004_ref_inativas` ( 
				`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
				PRIMARY KEY (`id`),
				`id_categoria` INT UNSIGNED NULL,
				`data` DATE NULL,
				`nome` VARCHAR(80) NOT NULL,
				`cpf` VARCHAR(80) NOT NULL,
				`celular` VARCHAR(80) NOT NULL,
				`email` VARCHAR(80) NOT NULL,
				`cidade` VARCHAR(80) NULL,
				`uf` VARCHAR(80) NULL,
				`regiao` VARCHAR(80) NULL,
				`quantidade` VARCHAR(80) NULL,
				`unidade` VARCHAR(80) NULL,
				`uta` VARCHAR(80) NULL,
				`valor` VARCHAR(80) NULL,
				`obs` TEXT NULL,
				`situacao` VARCHAR(80) NULL
			) CHARSET utf8",
			$silent
		);
		setupIndexes('c004_ref_inativas', ['id_categoria',]);



		// save MD5
		@file_put_contents(dirname(__FILE__) . '/setup.md5', $thisMD5);
	}


	function setupIndexes($tableName, $arrFields) {
		if(!is_array($arrFields) || !count($arrFields)) return false;

		foreach($arrFields as $fieldName) {
			if(!$res = @db_query("SHOW COLUMNS FROM `$tableName` like '$fieldName'")) continue;
			if(!$row = @db_fetch_assoc($res)) continue;
			if($row['Key']) continue;

			@db_query("ALTER TABLE `$tableName` ADD INDEX `$fieldName` (`$fieldName`)");
		}
	}


	function setupTable($tableName, $createSQL = '', $silent = true, $arrAlter = '') {
		global $Translation;
		$oldTableName = '';
		ob_start();

		echo '<div style="padding: 5px; border-bottom:solid 1px silver; font-family: verdana, arial; font-size: 10px;">';

		// is there a table rename query?
		if(is_array($arrAlter)) {
			$matches = [];
			if(preg_match("/ALTER TABLE `(.*)` RENAME `$tableName`/i", $arrAlter[0], $matches)) {
				$oldTableName = $matches[1];
			}
		}

		if($res = @db_query("SELECT COUNT(1) FROM `$tableName`")) { // table already exists
			if($row = @db_fetch_array($res)) {
				echo str_replace(['<TableName>', '<NumRecords>'], [$tableName, $row[0]], $Translation['table exists']);
				if(is_array($arrAlter)) {
					echo '<br>';
					foreach($arrAlter as $alter) {
						if($alter != '') {
							echo "$alter ... ";
							if(!@db_query($alter)) {
								echo '<span class="label label-danger">' . $Translation['failed'] . '</span>';
								echo '<div class="text-danger">' . $Translation['mysql said'] . ' ' . db_error(db_link()) . '</div>';
							} else {
								echo '<span class="label label-success">' . $Translation['ok'] . '</span>';
							}
						}
					}
				} else {
					echo $Translation['table uptodate'];
				}
			} else {
				echo str_replace('<TableName>', $tableName, $Translation['couldnt count']);
			}
		} else { // given tableName doesn't exist

			if($oldTableName != '') { // if we have a table rename query
				if($ro = @db_query("SELECT COUNT(1) FROM `$oldTableName`")) { // if old table exists, rename it.
					$renameQuery = array_shift($arrAlter); // get and remove rename query

					echo "$renameQuery ... ";
					if(!@db_query($renameQuery)) {
						echo '<span class="label label-danger">' . $Translation['failed'] . '</span>';
						echo '<div class="text-danger">' . $Translation['mysql said'] . ' ' . db_error(db_link()) . '</div>';
					} else {
						echo '<span class="label label-success">' . $Translation['ok'] . '</span>';
					}

					if(is_array($arrAlter)) setupTable($tableName, $createSQL, false, $arrAlter); // execute Alter queries on renamed table ...
				} else { // if old tableName doesn't exist (nor the new one since we're here), then just create the table.
					setupTable($tableName, $createSQL, false); // no Alter queries passed ...
				}
			} else { // tableName doesn't exist and no rename, so just create the table
				echo str_replace("<TableName>", $tableName, $Translation["creating table"]);
				if(!@db_query($createSQL)) {
					echo '<span class="label label-danger">' . $Translation['failed'] . '</span>';
					echo '<div class="text-danger">' . $Translation['mysql said'] . db_error(db_link()) . '</div>';
				} else {
					echo '<span class="label label-success">' . $Translation['ok'] . '</span>';
				}
			}
		}

		echo '</div>';

		$out = ob_get_clean();
		if(!$silent) echo $out;
	}
